/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.module;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.st0x0ef.stellaris.common.data_components.JetSuitComponent;
import com.st0x0ef.stellaris.common.items.armors.JetSuit;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_9331;
import net.minecraft.class_9779;

public class JetModule
extends class_1792
implements SpaceSuitModule {
    public float spacePressTime;
    private boolean isGliding = false;

    public JetModule(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    @Override
    public class_5250 displayName() {
        return class_2561.method_43471((String)"spacesuit.stellaris.jet_module");
    }

    @Override
    public List<class_1792> requires() {
        return List.of((class_1792)ItemsRegistry.MODULE_FUEL.get());
    }

    @Override
    public int renderStackedGui(class_332 graphics, class_9779 deltaTracker, class_1657 player, class_1799 stack, int y) {
        class_2561 modeText = this.getModeType(stack).getComponent();
        class_124 chatFormatting = this.getModeType(stack).getChatFormatting();
        class_327 font = class_310.method_1551().field_1772;
        class_5250 text = class_2561.method_43471((String)"general.stellaris.jet_suit_mode").method_27693(": ").method_27692(chatFormatting).method_10852((class_2561)modeText.method_27661().method_27692(class_124.field_1080));
        graphics.method_27535(font, (class_2561)text, 5, y, 0xFFFFFF);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return y += 9;
    }

    public int getMode(class_1799 itemStack) {
        return ((JetSuitComponent)itemStack.method_57825((class_9331)DataComponentsRegistry.JET_SUIT_COMPONENT.get(), (Object)new JetSuitComponent(JetSuit.ModeType.DISABLED))).type().getMode();
    }

    public JetSuit.ModeType getModeType(class_1799 itemStack) {
        return switch (this.getMode(itemStack)) {
            case 1 -> JetSuit.ModeType.NORMAL;
            case 2 -> JetSuit.ModeType.HOVER;
            case 3 -> JetSuit.ModeType.ELYTRA;
            default -> JetSuit.ModeType.DISABLED;
        };
    }

    @Override
    public void tick(class_1799 stack, class_1937 level, class_1657 player) {
        UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
        if (storage == null || storage.getFluidInTank(1).isEmpty()) {
            return;
        }
        if (player.method_5624()) {
            this.boost(player, 1.3, true);
        }
        if (player.field_6250 > 0.0f && !player.method_5624()) {
            this.boost(player, 0.9, false);
        }
        switch (this.getMode(stack)) {
            case 1: {
                this.normalFlyModeMovement(player, stack);
                break;
            }
            case 2: {
                this.hoverModeMovement(player, stack);
                break;
            }
            case 3: {
                this.elytraModeMovement(player, stack);
            }
        }
        this.calculateSpacePressTime(player, stack);
    }

    private void normalFlyModeMovement(class_1657 player, class_1799 stack) {
        if (KeyVariables.isHoldingJump(player)) {
            player.method_5724(1.2f, new class_243(0.0, 0.1, 0.0));
            player.method_38785();
            Utils.disableFlyAntiCheat(player, true);
        }
        if (!player.method_24828()) {
            if (KeyVariables.isHoldingUp(player)) {
                player.method_5724(1.0f, new class_243(0.0, 0.0, 0.03));
            } else if (KeyVariables.isHoldingDown(player)) {
                player.method_5724(1.0f, new class_243(0.0, 0.0, -0.03));
            }
        }
        if (!player.method_24828()) {
            if (KeyVariables.isHoldingRight(player)) {
                player.method_5724(1.0f, new class_243(-0.03, 0.0, 0.0));
            } else if (KeyVariables.isHoldingLeft(player)) {
                player.method_5724(1.0f, new class_243(0.03, 0.0, 0.0));
            }
        }
    }

    private void hoverModeMovement(class_1657 player, class_1799 stack) {
        class_243 vec3 = player.method_18798();
        if (!player.method_24828() && !player.method_5799()) {
            player.method_18800(vec3.field_1352, vec3.field_1351 + 0.04, vec3.field_1350);
            player.method_38785();
            Utils.disableFlyAntiCheat(player, true);
            UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
            if (storage == null) {
                return;
            }
            storage.drain(FluidStack.create((class_3611)((class_3611)FluidRegistry.FUEL_STILL.get()), (long)2L), false);
        }
        if (KeyVariables.isHoldingJump(player)) {
            Utils.disableFlyAntiCheat(player, true);
        }
        if (player.method_18276()) {
            player.method_5724(0.05f, new class_243(0.0, -0.08, 0.0));
        }
        if (!player.method_24828()) {
            if (KeyVariables.isHoldingUp(player)) {
                player.method_5724(0.1f, new class_243(0.0, 0.0, 0.1));
            } else if (KeyVariables.isHoldingDown(player)) {
                player.method_5724(0.1f, new class_243(0.0, 0.0, -0.1));
            }
        }
        if (!player.method_24828()) {
            if (KeyVariables.isHoldingRight(player)) {
                player.method_5724(0.1f, new class_243(-0.1, 0.0, 0.0));
            } else if (KeyVariables.isHoldingLeft(player)) {
                player.method_5724(0.1f, new class_243(0.1, 0.0, 0.0));
            }
        }
    }

    private void elytraModeMovement(class_1657 player, class_1799 stack) {
        if (player.method_5624() && !player.method_24828()) {
            player.method_23669();
            Utils.disableFlyAntiCheat(player, true);
            UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
            if (storage == null) {
                return;
            }
            storage.drain(FluidStack.create((class_3611)((class_3611)FluidRegistry.FUEL_STILL.get()), (long)2L), false);
        } else if (player.method_5624() && player.method_24828() && KeyVariables.isHoldingJump(player)) {
            player.method_24203(player.method_23317(), player.method_23318() + 2.0, player.method_23321());
        } else if (player.method_18276() && player.method_6128()) {
            player.method_23670();
        }
        if (this.isGliding) {
            player.method_18800(player.method_18798().method_10216(), 0.0, player.method_18798().method_10215());
            if (!player.method_24828()) {
                player.method_18800(player.method_18798().method_10216(), -0.1, player.method_18798().method_10215());
            } else {
                this.isGliding = false;
                player.method_23670();
            }
        }
    }

    public void switchJetSuitMode(class_1799 itemStack) {
        JetSuitComponent jetSuitComponent = this.getMode(itemStack) < 3 ? new JetSuitComponent(JetSuit.ModeType.fromInt(this.getMode(itemStack) + 1)) : new JetSuitComponent(JetSuit.ModeType.fromInt(0));
        itemStack.method_57379((class_9331)DataComponentsRegistry.JET_SUIT_COMPONENT.get(), (Object)jetSuitComponent);
    }

    public void calculateSpacePressTime(class_1657 player, class_1799 itemStack) {
        int mode;
        if (Utils.isLivingInJetSuit((class_1309)player) && (mode = this.getMode(itemStack)) == JetSuit.ModeType.ELYTRA.getMode()) {
            if (KeyVariables.isHoldingUp(player) && player.method_6128()) {
                if (player.method_5624()) {
                    if (this.spacePressTime < 2.8f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime < 2.2f) {
                    this.spacePressTime += 0.2f;
                }
                if (this.spacePressTime >= 2.0f && !this.isGliding) {
                    this.startGliding(player);
                }
            } else if (this.spacePressTime > 0.0f) {
                this.spacePressTime -= 0.2f;
                if (this.spacePressTime <= 0.0f) {
                    this.isGliding = false;
                }
            }
        }
    }

    private void startGliding(class_1657 player) {
        this.isGliding = true;
        player.method_23670();
        player.method_18800(player.method_18798().method_10216(), 0.0, player.method_18798().method_10215());
    }

    public void boost(class_1657 player, double boost, boolean sonicBoom) {
        class_243 vec31 = player.method_5720();
        if (Utils.isLivingInJetSuit((class_1309)player) && player.method_6128()) {
            class_243 vec32 = player.method_18798();
            player.method_18799(vec32.method_1031(vec31.field_1352 * 0.1 + (vec31.field_1352 * boost - vec32.field_1352) * 0.5, vec31.field_1351 * 0.1 + (vec31.field_1351 * boost - vec32.field_1351) * 0.5, vec31.field_1350 * 0.1 + (vec31.field_1350 * boost - vec32.field_1350) * 0.5));
            if (sonicBoom) {
                class_243 vec33 = player.method_5720().method_1021(6.5);
                if (player.method_37908() instanceof class_3218) {
                    for (class_3222 p : ((class_3218)player.method_37908()).method_8503().method_3760().method_14571()) {
                        ((class_3218)player.method_37908()).method_14166(p, (class_2394)class_2398.field_17909, true, player.method_23317() - vec33.field_1352, player.method_23318() - vec33.field_1351, player.method_23321() - vec33.field_1350, 1, 0.0, 0.0, 0.0, 0.001);
                    }
                }
            }
        }
    }
}

