/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipe;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadLauncher;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import com.st0x0ef.stellaris.common.network.packets.TeleportEntityToPlanetPacket;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class PlaceStationPacket
implements class_8710 {
    public final class_2960 dimension;
    public final SpaceStationRecipe recipe;
    public final LaunchPad pad;
    public static final class_9139<class_9129, PlaceStationPacket> STREAM_CODEC = new class_9139<class_9129, PlaceStationPacket>(){

        @NotNull
        public PlaceStationPacket decode(class_9129 buf) {
            return new PlaceStationPacket(buf);
        }

        public void encode(class_9129 buf, PlaceStationPacket packet) {
            buf.method_10812(packet.dimension);
            SpaceStationRecipe.toBuffer(packet.recipe, buf);
            LaunchPad.toBuffer(packet.pad, buf);
        }
    };

    public PlaceStationPacket(class_2960 dimension, SpaceStationRecipe recipe, LaunchPad pad) {
        this.dimension = dimension;
        this.recipe = recipe;
        this.pad = pad;
    }

    public PlaceStationPacket(class_9129 buffer) {
        this.dimension = buffer.method_10810();
        this.recipe = SpaceStationRecipe.readFromBuffer(buffer);
        this.pad = LaunchPad.readFromBuffer(buffer);
    }

    public static void handle(PlaceStationPacket packet, NetworkManager.PacketContext context) {
        class_3218 level;
        class_1657 player = context.getPlayer();
        Planet planet = PlanetUtil.getPlanet(packet.dimension);
        if (planet != null && (level = player.method_37908().method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)planet.dimension()))) != null) {
            class_243 stationPosition = Utils.placeSpaceStation(player, level, packet.recipe, packet.pad);
            if (!player.method_7337() && !player.method_7325()) {
                packet.recipe.removeMaterials(player);
            }
            LaunchPad newPad = new LaunchPad(packet.pad.id(), stationPosition, packet.pad.dimension(), packet.pad.name(), packet.pad.isPublic(), packet.pad.owner(), packet.pad.whitelist());
            LaunchPadLauncher.addLaunchPad(newPad, context.getPlayer().method_5682());
            TeleportEntityToPlanetPacket.teleportToPlanet(player, packet.dimension, stationPosition);
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return NetworkRegistry.PLACE_STATION_ID;
    }
}

