/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class OxygenRoom {
    private final class_2338 distributorPos;
    public final Set<class_2338> oxygenatedPositions;
    private final class_3218 level;

    public OxygenRoom(class_3218 level, class_2338 distributorPos) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = new HashSet<class_2338>();
        this.level = level;
    }

    public class_2338 getDistributorPosition() {
        return this.distributorPos;
    }

    public OxygenDistributorBlockEntity getDistributorBlockEntity() {
        OxygenDistributorBlockEntity distributor;
        class_2586 class_25862 = this.level.method_8321(this.distributorPos);
        return class_25862 instanceof OxygenDistributorBlockEntity ? (distributor = (OxygenDistributorBlockEntity)class_25862) : null;
    }

    public void tick() {
        OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
        if (distributor == null) {
            return;
        }
        LinkedList<class_2338> toExplore = new LinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>(this.oxygenatedPositions);
        HashSet<class_2338> newPositions = new HashSet<class_2338>();
        for (class_2350 direction : class_2350.values()) {
            class_2338 rel = this.distributorPos.method_10093(direction);
            if (visited.contains(rel) || !this.level.method_8320(rel).method_26215()) continue;
            toExplore.offer(rel);
            visited.add(rel);
        }
        while (!toExplore.isEmpty()) {
            class_2338 currentPos = (class_2338)toExplore.poll();
            if (!this.level.method_8320(currentPos).method_26215()) continue;
            newPositions.add(currentPos);
            for (class_2350 direction : class_2350.values()) {
                class_2338 rel = currentPos.method_10093(direction);
                if (visited.contains(rel)) continue;
                visited.add(rel);
                int HalfRoomSize = Stellaris.CONFIG.oxygenConfig.maxOxygenRoomSize / 2;
                if (Math.abs(rel.method_10263() - this.distributorPos.method_10263()) > HalfRoomSize || Math.abs(rel.method_10264() - this.distributorPos.method_10264()) > HalfRoomSize || Math.abs(rel.method_10260() - this.distributorPos.method_10260()) > HalfRoomSize) {
                    GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).addRoomToCheckIfOpen(rel, this);
                    continue;
                }
                if (!this.level.method_8320(rel).method_26215()) continue;
                toExplore.offer(rel);
            }
        }
        for (class_2338 pos : newPositions) {
            if (this.oxygenatedPositions.contains(pos) || !distributor.useOxygenAndEnergy()) continue;
            this.oxygenatedPositions.add(pos);
            GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).removeRoomToCheckIfOpen(pos);
        }
    }

    public void removeOxygenInRoom() {
        this.oxygenatedPositions.clear();
    }

    public boolean hasOxygenAt(class_2338 pos) {
        return this.oxygenatedPositions.contains(pos);
    }

    public boolean breathOxygenAt(class_2338 pos) {
        if (this.hasOxygenAt(pos)) {
            OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
            if (this.getDistributorBlockEntity() == null || !distributor.useOxygenAndEnergy()) {
                this.oxygenatedPositions.remove(pos);
            }
            return true;
        }
        return false;
    }
}

