/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipe;
import com.st0x0ef.stellaris.common.data_components.SpaceSuitModules;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.TeleportUtil;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static void transfertInventory(RocketEntity rocket, LanderEntity lander) {
        class_1263 rocketContainer = rocket.getInventory();
        class_1263 landerContainer = lander.getInventory();
        for (int i = 2; i < lander.getInventory().method_5439() - 1; ++i) {
            landerContainer.method_5447(i, rocketContainer.method_5438(i));
        }
        class_1799 rocketStack = new class_1799((class_1935)ItemsRegistry.ROCKET.get());
        rocketStack.method_57379((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)rocket.getRocketComponent());
        landerContainer.method_5447(14, rocketStack);
    }

    public static LanderEntity createLanderFromRocket(RocketEntity rocket, class_243 coords, class_1937 destination) {
        LanderEntity lander = new LanderEntity(destination);
        class_243 landerOffset = new class_243(0.5, 0.0, -0.5);
        lander.method_5814(coords.field_1352 + landerOffset.field_1352, coords.field_1351, coords.field_1350 + landerOffset.field_1350);
        Utils.transfertInventory(rocket, lander);
        rocket.method_31472();
        return lander;
    }

    public static void teleportEntity(class_1297 entity, Planet destination, class_243 coords) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        entity.method_5875(false);
        TeleportUtil.teleportToPlanet(entity, Utils.getPlanetLevel(destination), coords);
    }

    public static void changeDimension(class_1657 player, Planet destination) {
        Utils.changeDimension(player, destination, new class_243((double)((int)player.method_23317()), (double)Stellaris.CONFIG.rocketTpHeight, (double)((int)player.method_23321())));
    }

    public static void changeDimension(class_1657 player, Planet destination, class_243 coords) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1297 class_12972 = serverPlayer.method_5854();
            if (class_12972 instanceof RocketEntity) {
                RocketEntity rocket = (RocketEntity)class_12972;
                serverPlayer.method_5848();
                serverPlayer.method_7346();
                if (!serverPlayer.method_7337() && !serverPlayer.method_7325()) {
                    int fuelConsumption = Math.round(FuelType.getFuelNeededToGoOnPlanet(PlanetUtil.getPlanet(serverPlayer.method_37908().method_27983().method_29177()), destination, rocket.FUEL_TYPE));
                    rocket.FUEL -= fuelConsumption;
                    rocket.syncRocketData(serverPlayer);
                }
                LanderEntity lander = Utils.createLanderFromRocket(rocket, coords, (class_1937)Utils.getPlanetLevel(destination));
                Utils.teleportEntity((class_1297)serverPlayer, destination, lander.method_52538((class_1297)serverPlayer));
                player.method_7339((class_2960)StatsRegistry.SPACE_TRAVEL.get(), Utils.distanceToPlanet(PlanetUtil.getPlanet(player.method_37908().method_27983().method_29177()), destination));
                serverPlayer.method_37908().method_8649((class_1297)lander);
                while (!serverPlayer.method_5873((class_1297)lander, true)) {
                }
                serverPlayer.method_43496((class_2561)class_2561.method_43471((String)"message.stellaris.lander"));
            } else {
                serverPlayer.method_7346();
                Utils.teleportEntity((class_1297)serverPlayer, destination, coords);
            }
        }
    }

    public static void changeDimensionWithVehicle(class_1297 entity, Planet destination, class_243 coords) {
        class_1297 vehicle = entity.method_5854();
        entity.method_5848();
        Utils.teleportEntity(entity, destination, coords);
        if (vehicle != null) {
            Utils.teleportEntity(vehicle, destination, coords);
            entity.method_5873(vehicle, true);
        }
    }

    public static void changeDimensionForPlayers(List<class_1297> entities, Planet destination, class_243 coords, boolean setHeight) {
        if (setHeight) {
            coords = new class_243(coords.field_1352, (double)Stellaris.CONFIG.rocketTpHeight, coords.field_1350);
        }
        Utils.changeDimensionForPlayers(entities, destination, coords);
    }

    public static void changeDimensionForPlayers(List<class_1297> entities, Planet destination, class_243 coords) {
        RocketEntity rocket = (RocketEntity)entities.getFirst().method_5854();
        for (class_1297 entity : entities) {
            if (entity.method_37908().method_8608()) {
                return;
            }
            class_1297 vehicle = entity.method_5854();
            if (!(vehicle instanceof RocketEntity)) continue;
            RocketEntity playerRocket = (RocketEntity)vehicle;
            entity.method_5848();
            rocket = playerRocket;
            Utils.teleportEntity(entity, destination, coords);
            if (!(entity instanceof class_1657)) continue;
            class_1657 player = (class_1657)entity;
            player.method_7339((class_2960)StatsRegistry.SPACE_TRAVEL.get(), Utils.distanceToPlanet(PlanetUtil.getPlanet(player.method_37908().method_27983().method_29177()), destination));
            player.method_7346();
            player.stellaris$setPlanetMenuOpen(false, player, true);
        }
        LanderEntity lander = Utils.createLanderFromRocket(rocket, coords, (class_1937)Utils.getPlanetLevel(destination));
        entities.getFirst().method_37908().method_8649((class_1297)lander);
        for (class_1297 entity : entities) {
            entity.method_5873((class_1297)lander, true);
            entity.method_43496((class_2561)class_2561.method_43471((String)"message.stellaris.lander"));
        }
    }

    public static int distanceToPlanet(Planet actual, Planet destination) {
        return class_3532.method_15382((int)(actual.distanceFromEarth() - destination.distanceFromEarth()));
    }

    public static double changeLastDigitToEven(double number) {
        Object numberStr = Double.toString(number);
        int decimalIndex = ((String)numberStr).indexOf(46);
        if (decimalIndex != -1) {
            String beforeDecimal = ((String)numberStr).substring(0, decimalIndex + 1);
            Object afterDecimal = ((String)numberStr).substring(decimalIndex + 1);
            char lastChar = ((String)afterDecimal).charAt(((String)afterDecimal).length() - 1);
            if ((lastChar - 48) % 2 != 0) {
                afterDecimal = ((String)afterDecimal).substring(0, ((String)afterDecimal).length() - 1) + "2";
            }
            numberStr = beforeDecimal + (String)afterDecimal;
        }
        return Double.parseDouble((String)numberStr);
    }

    public static int getColorHexCode(String colorName) {
        if (colorName.startsWith("#")) {
            try {
                return Integer.parseInt(colorName.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return 0xFFFFFF;
            }
        }
        return switch (colorName.toLowerCase()) {
            case "black" -> 0;
            case "red" -> 0xFF0000;
            case "green" -> 32768;
            case "blue" -> 255;
            case "yellow" -> 0xFFFF00;
            case "cyan" -> 65535;
            case "magenta" -> 0xFF00FF;
            case "gray", "grey" -> 0x808080;
            case "maroon" -> 0x800000;
            case "olive" -> 0x808000;
            case "purple" -> 0x800080;
            case "teal" -> 32896;
            case "navy" -> 128;
            case "orange" -> 16753920;
            case "brown" -> 0xA52A2A;
            case "lime" -> 65280;
            case "pink" -> 16761035;
            case "coral" -> 16744272;
            case "gold" -> 16766720;
            case "silver" -> 0xC0C0C0;
            case "beige" -> 16119260;
            case "lavender" -> 15132410;
            case "turquoise" -> 4251856;
            case "salmon" -> 16416882;
            case "khaki" -> 15787660;
            case "darkred" -> 0x8B0000;
            case "dark_red" -> 0x8B0000;
            case "rainbow" -> Utils.generateRandomHexColor();
            default -> 0xFFFFFF;
        };
    }

    public static int generateRandomHexColor() {
        Random random = new Random();
        return random.nextInt(0x1000000);
    }

    public static String betterIntToString(int i) {
        if (i == 0) {
            return "0";
        }
        return i % 1000 + "K";
    }

    public static class_2561 getMessageComponent(String text, String color) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)Utils.getColorHexCode(color))));
    }

    public static class_2561 getMessageComponent(String text, int color) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color)));
    }

    public static class_2561 getMessageComponent(String text) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360);
    }

    public static int getPlayerCountInDimension(MinecraftServer server, class_2960 dimensionKey) {
        class_3218 dimension = server.method_3847(Utils.getPlanetLevel(dimensionKey));
        if (dimension == null) {
            return 0;
        }
        return dimension.method_18456().size();
    }

    public static <T extends Enum<T>> Codec<T> EnumCodec(Class<T> e) {
        Function<String, Enum> stringToEnum = s -> Enum.valueOf(e, s.toUpperCase(Locale.ROOT));
        Function<Enum, String> enumToString = Enum::name;
        return Codec.STRING.xmap(stringToEnum, enumToString);
    }

    public static float MCGToMPS2(float MCG) {
        return 122.58312f * MCG;
    }

    public static double MPS2ToMCG(float MPS2) {
        if (MPS2 > 0.0f) {
            return Math.floor(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        if (MPS2 < 0.0f) {
            return Math.ceil(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        return 0.0;
    }

    public static void disableFlyAntiCheat(class_1657 player, boolean condition) {
        if (player instanceof class_3222 && condition) {
            ((class_3222)player).field_13987.field_14138 = 0;
        }
    }

    public static boolean isLivingInJetSuit(class_1309 entity) {
        return Utils.isLivingInArmor(entity, class_1304.field_6166, (class_1792)ItemsRegistry.JETSUIT_BOOTS.get()) && Utils.isLivingInArmor(entity, class_1304.field_6169, (class_1792)ItemsRegistry.JETSUIT_HELMET.get()) && Utils.isLivingInArmor(entity, class_1304.field_6174, (class_1792)ItemsRegistry.JETSUIT_SUIT.get()) && Utils.isLivingInArmor(entity, class_1304.field_6172, (class_1792)ItemsRegistry.JETSUIT_LEGGINGS.get());
    }

    public static boolean isLivingInSpaceSuit(class_1309 entity) {
        return Utils.isLivingInArmor(entity, class_1304.field_6166, (class_1792)ItemsRegistry.SPACESUIT_BOOTS.get()) && Utils.isLivingInArmor(entity, class_1304.field_6172, (class_1792)ItemsRegistry.SPACESUIT_LEGGINGS.get()) && Utils.isLivingInArmor(entity, class_1304.field_6174, (class_1792)ItemsRegistry.SPACESUIT_SUIT.get()) && Utils.isLivingInArmor(entity, class_1304.field_6169, (class_1792)ItemsRegistry.SPACESUIT_HELMET.get());
    }

    public static boolean isLivingInArmor(class_1309 entity, class_1304 slot, class_1792 item) {
        return entity.method_6118(slot).method_7909() == item;
    }

    public static class_5321<class_1937> getPlanetLevel(class_2960 planet) {
        return class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)planet), (class_2960)planet);
    }

    public static class_3218 getPlanetLevel(Planet planet) {
        for (class_3218 level : GameInstance.getServer().method_3738()) {
            if (!level.method_27983().method_29177().equals((Object)planet.dimension())) continue;
            return level;
        }
        return null;
    }

    public static boolean entityHasBlockAbove(class_1309 entity, @Nullable class_2338 pos, @Nullable Integer recusion) {
        return entity.method_37908().method_8311(entity.method_24515());
    }

    public static class_2338 getBlockPosFromVector3i(class_243 vec3) {
        return new class_2338((int)vec3.field_1352, (int)vec3.field_1351, (int)vec3.field_1350);
    }

    public <T> void addButtonToList(ArrayList<ArrayList<T>> finalList, T button, int size) {
        if (finalList.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>();
            list.add(button);
            finalList.add(list);
            return;
        }
        for (ArrayList<T> buttons : finalList) {
            if (buttons.size() < size) {
                buttons.add(button);
                break;
            }
            if (buttons.size() != size || finalList.indexOf(buttons) + 1 < finalList.size()) continue;
            ArrayList<T> list = new ArrayList<T>();
            list.add(button);
            finalList.add(list);
            break;
        }
    }

    public static class_243 placeSpaceStation(class_1657 player, class_3218 serverLevel, SpaceStationRecipe recipe, LaunchPad pad) {
        class_3499 structureTemplate = serverLevel.method_14183().method_15091(recipe.location());
        class_2338 pos = new class_2338((int)player.method_23317() - structureTemplate.method_15160().method_10263() / 2, 100, (int)player.method_23321() - structureTemplate.method_15160().method_10260() / 2);
        structureTemplate.method_15172((class_5425)serverLevel, pos, pos, new class_3492(), serverLevel.field_9229, 2);
        return Utils.placeAntennaBlock(pos, serverLevel, recipe, pad);
    }

    public static class_243 placeAntennaBlock(class_2338 initialPos, class_3218 serverLevel, SpaceStationRecipe recipe, LaunchPad pad) {
        class_2338 pos = initialPos.method_10069((int)recipe.antenna_position().field_1352, (int)recipe.antenna_position().field_1351, (int)recipe.antenna_position().field_1350);
        AntennaBlockEntity antennaBlockEntity = new AntennaBlockEntity(pos, ((class_2248)BlocksRegistry.ANTENNA.get()).method_9564());
        LaunchPad newPad = new LaunchPad(pad.id(), Utils.blockPosToVec3(pos), pad.dimension(), pad.name(), pad.isPublic(), pad.owner(), pad.whitelist());
        antennaBlockEntity.setLaunchPad(newPad, true);
        serverLevel.method_8652(pos, ((class_2248)BlocksRegistry.ANTENNA.get()).method_9564(), 1);
        serverLevel.method_8438((class_2586)antennaBlockEntity);
        return Utils.blockPosToVec3(pos);
    }

    public static boolean isHoveredOnSprite(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public static class_243 blockPosToVec3(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static void handleGravityChange(class_1309 entity, class_1937 level) {
        if (!SpaceSuitModules.containsInModules(entity.method_6118(class_1304.field_6174), ((class_1792)ItemsRegistry.MODULE_GRAVITY_NORMALIZER.get()).method_7854())) {
            class_2960 dimension = level.method_27983().method_29177();
            if (!PlanetUtil.isPlanet(dimension) || dimension.equals((Object)StellarisData.OVERWORLD) || !Stellaris.CONFIG.gravityConfig.customEntityGravity) {
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49078, ((class_1320)class_5134.field_49078.comp_349()).method_6169());
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49079, ((class_1320)class_5134.field_49079.comp_349()).method_6169());
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49077, ((class_1320)class_5134.field_49077.comp_349()).method_6169());
            } else if (PlanetUtil.isPlanet(dimension)) {
                float stellaris$regularGravity = PlanetUtil.getPlanet(dimension).gravity();
                double stellaris$gravity = Utils.MPS2ToMCG(stellaris$regularGravity);
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49078, ((class_1320)class_5134.field_49078.comp_349()).method_6165(stellaris$gravity));
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49079, ((class_1320)class_5134.field_49079.comp_349()).method_6165(3.0 / ((double)stellaris$regularGravity / 9.80665)));
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49077, ((class_1320)class_5134.field_49077.comp_349()).method_6165((double)stellaris$regularGravity / 9.80665));
            }
        }
    }

    public static void trySetAttribute(class_1309 entity, class_6880<class_1320> attribute, double value) {
        class_1324 attributeInstance = entity.method_5996(attribute);
        if (attributeInstance != null) {
            attributeInstance.method_6192(value);
        }
    }
}

