/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fabric.energy;

import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;

public class FabricEnergyStorage
extends SnapshotParticipant<Integer>
implements EnergyStorage {
    final UniversalEnergyStorage universalEnergyStorage;

    public FabricEnergyStorage(@NotNull UniversalEnergyStorage universalEnergyStorage) {
        this.universalEnergyStorage = universalEnergyStorage;
    }

    public long insert(long amount, TransactionContext transaction) {
        if (this.universalEnergyStorage.insert((int)amount, true) > 0) {
            this.updateSnapshots(transaction);
            return this.universalEnergyStorage.insert((int)amount, false);
        }
        return 0L;
    }

    public long extract(long amount, TransactionContext transaction) {
        if (this.universalEnergyStorage.extract((int)amount, true) > 0) {
            this.updateSnapshots(transaction);
            return this.universalEnergyStorage.extract((int)amount, false);
        }
        return 0L;
    }

    public long getAmount() {
        return this.universalEnergyStorage.getEnergy();
    }

    public long getCapacity() {
        return this.universalEnergyStorage.getMaxEnergy();
    }

    protected Integer createSnapshot() {
        return this.universalEnergyStorage.getEnergy();
    }

    public boolean supportsExtraction() {
        return this.universalEnergyStorage.canExtractEnergy();
    }

    public boolean supportsInsertion() {
        return this.universalEnergyStorage.canInsertEnergy();
    }

    protected void readSnapshot(Integer integer) {
        this.universalEnergyStorage.extract(Integer.MAX_VALUE, false);
        this.universalEnergyStorage.insert(integer, false);
    }
}

