/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fabric.fluid;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class SingleSlotFluidStorage
implements SingleSlotStorage<FluidVariant> {
    private final UniversalFluidStorage fluidStorage;
    private final int slot;

    public SingleSlotFluidStorage(UniversalFluidStorage fluidStorage, int slot) {
        this.fluidStorage = fluidStorage;
        this.slot = slot;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.fluidStorage.fill(FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)(maxAmount / 81L)), false) * 81L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.fluidStorage.drain(FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)(maxAmount / 81L)), false).getAmount() * 81L;
    }

    public boolean isResourceBlank() {
        return this.fluidStorage.getFluidInTank(this.slot).isEmpty();
    }

    public FluidVariant getResource() {
        return FluidStackHooksFabric.toFabric((FluidStack)this.fluidStorage.getFluidInTank(this.slot));
    }

    public long getAmount() {
        return this.fluidStorage.getFluidInTank(this.slot).getAmount() * 81L;
    }

    public long getCapacity() {
        return this.fluidStorage.getTankCapacity(this.slot) * 81L;
    }
}

