/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import net.abraxator.moresnifferflowers.blockentities.IModBlockEntity;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.nikdo53.tinymultiblocklib.blockentities.AbstractMultiBlockEntity;
import org.jetbrains.annotations.Nullable;

public class GiantCropBlockEntity
extends AbstractMultiBlockEntity
implements IModBlockEntity {
    public boolean canGrow = false;
    public double growProgress = 0.0;
    public int state = 0;
    public float staticGameTime;

    public GiantCropBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GIANT_CROP.get(), pos, state);
    }

    @Override
    public void tick(Level level) {
        if (this.canGrow) {
            if (this.staticGameTime == 0.0f) {
                this.staticGameTime = level.getGameTime();
            }
            this.growProgress += 0.1;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            if (this.growProgress >= 1.0) {
                this.canGrow = false;
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("canGrow", this.canGrow);
        tag.putDouble("growProgress", this.growProgress);
        tag.putFloat("staticGameTime", this.staticGameTime);
        tag.putInt("state", this.state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.canGrow = tag.getBoolean("canGrow");
        this.growProgress = tag.getDouble("growProgress");
        this.staticGameTime = tag.getFloat("staticGameTime");
        this.state = tag.getInt("state");
    }
}

