/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.abraxator.moresnifferflowers.blocks.rebrewingstand.RebrewingStandBlockBase;
import net.abraxator.moresnifferflowers.client.gui.menu.RebrewingStandMenu;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import oshi.util.tuples.Pair;

public class RebrewingStandBlockEntity
extends BaseContainerBlockEntity {
    public static final double MAX_FUEL = 16.0;
    public static final int DATA_PROGRESS = 0;
    public static final int DATA_FUEL = 1;
    public static final int DATA_COST = 2;
    public static final int MAX_PROGRESS = 100;
    private NonNullList<ItemStack> inv = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    int brewProgress;
    int fuel;
    int cost;
    private boolean[] lastPotionCount;
    public final ContainerData containerData = new ContainerData(){

        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> RebrewingStandBlockEntity.this.brewProgress;
                case 1 -> RebrewingStandBlockEntity.this.fuel;
                case 2 -> RebrewingStandBlockEntity.this.cost;
                default -> 0;
            };
        }

        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    RebrewingStandBlockEntity.this.brewProgress = pValue;
                    break;
                }
                case 1: {
                    RebrewingStandBlockEntity.this.fuel = pValue;
                    break;
                }
                case 2: {
                    RebrewingStandBlockEntity.this.cost = pValue;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public RebrewingStandBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REBREWING_STAND.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.literal((String)"");
    }

    public boolean isEmpty() {
        return this.inv.stream().allMatch(Predicate.not(ItemStack::isEmpty));
    }

    public void tick(Level level) {
        ItemStack fuelStack = (ItemStack)this.inv.get(0);
        ItemStack ogPotionStack = (ItemStack)this.inv.get(1);
        ItemStack ingredientStack = (ItemStack)this.inv.get(2);
        boolean[] potionBits = this.getPotionBits();
        this.cost = 0;
        if ((double)this.fuel < 16.0 && fuelStack.is((Item)ModItems.CROPRESSED_NETHERWART.get())) {
            ++this.fuel;
            fuelStack.shrink(1);
            this.setChanged();
        }
        if (!ogPotionStack.isEmpty()) {
            Pair<PotionContents, List<MobEffectInstance>> potionContent = this.getPotionContents(ogPotionStack, ingredientStack);
            int n = this.cost = potionContent != null ? 4 + (((List)potionContent.getB()).size() - 2) * 2 : 17;
            if (this.canBrew()) {
                ++this.brewProgress;
                if (this.brewProgress >= 100) {
                    this.brew(level, ogPotionStack, ingredientStack);
                }
            }
        }
        if (!this.canBrew()) {
            this.brewProgress = 0;
        }
        if (!Arrays.equals(potionBits, this.lastPotionCount)) {
            this.bottleStateLogic(potionBits);
        }
    }

    private void brew(Level level, ItemStack ogPotionStack, ItemStack ingredientStack) {
        Pair<PotionContents, List<MobEffectInstance>> potionContent = this.getPotionContents(ogPotionStack, ingredientStack);
        if (potionContent != null) {
            List index = (List)Util.make((Object)Lists.newArrayList(), integers -> integers.addAll(Arrays.asList(3, 4, 5)));
            Iterator iterator = index.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ItemStack itemStack = (ItemStack)this.inv.get(i);
                if (itemStack.is(ItemStack.EMPTY.getItem())) continue;
                ItemStack outputPotion = ((Item)ModItems.REBREWED_POTION.get()).getDefaultInstance();
                if (ingredientStack.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_SPLASH.get()))) {
                    outputPotion = ((Item)ModItems.REBREWED_SPLASH_POTION.get()).getDefaultInstance();
                } else if (ingredientStack.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LINGERING.get()))) {
                    outputPotion = ((Item)ModItems.REBREWED_LINGERING_POTION.get()).getDefaultInstance();
                }
                outputPotion.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)potionContent.getA()));
                this.inv.set(i, (Object)outputPotion);
            }
            ingredientStack.shrink(1);
            this.fuel -= this.cost;
            this.inv.set(1, (Object)Items.GLASS_BOTTLE.getDefaultInstance());
            level.playSound(null, this.getBlockPos(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.brewProgress = 0;
    }

    private void bottleStateLogic(boolean[] potionBits) {
        this.lastPotionCount = potionBits;
        BlockState blockstate = this.level.getBlockState(this.getBlockPos().below());
        if (!(blockstate.getBlock() instanceof RebrewingStandBlockBase)) {
            return;
        }
        for (int i = 0; i < RebrewingStandBlockBase.HAS_BOTTLE.length; ++i) {
            blockstate = (BlockState)blockstate.setValue((Property)RebrewingStandBlockBase.HAS_BOTTLE[i], (Comparable)Boolean.valueOf(potionBits[i]));
        }
        this.level.setBlock(this.getBlockPos().below(), blockstate, 2);
    }

    private boolean canBrew() {
        boolean ret = false;
        boolean correctInvContent = !((ItemStack)this.inv.get(2)).isEmpty() && ((ItemStack)this.inv.get(1)).is((Item)ModItems.EXTRACTED_BOTTLE.get());
        boolean hasFuel = this.fuel >= 1 && this.fuel >= this.cost;
        boolean correctCost = this.cost <= 16;
        for (int i = 3; i <= 5; ++i) {
            if (((ItemStack)this.inv.get(i)).isEmpty() || ((ItemStack)this.inv.get(i)).is((Item)ModItems.REBREWED_POTION.get())) continue;
            ret = true;
        }
        return ret && correctInvContent && hasFuel && correctCost;
    }

    private boolean[] getPotionBits() {
        boolean[] ret = new boolean[3];
        for (int i = 3; i <= 5; ++i) {
            if (((ItemStack)this.inv.get(i)).isEmpty()) continue;
            ret[i - 3] = true;
        }
        return ret;
    }

    private Pair<PotionContents, List<MobEffectInstance>> getPotionContents(ItemStack inputPotion, ItemStack ingredient) {
        ArrayList<MobEffectInstance> ret = new ArrayList<MobEffectInstance>();
        ArrayList durList = new ArrayList();
        PotionContents potionContents = (PotionContents)inputPotion.get(DataComponents.POTION_CONTENTS);
        int defaultAmp = 1;
        int defaultDur = 6000;
        if (potionContents == null) {
            return null;
        }
        potionContents.forEachEffect(mobEffectInstance -> {
            int dur = mobEffectInstance.getDuration() + (ingredient.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_AMPLIFIER.get())) ? 12000 : defaultDur);
            int amp = mobEffectInstance.getAmplifier() + (ingredient.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LENGTH.get())) ? 2 : defaultAmp);
            durList.add(dur);
            ret.add(new MobEffectInstance(mobEffectInstance.getEffect(), dur, amp));
        });
        int maxInt = (Integer)Collections.max(durList);
        ret.add(new MobEffectInstance(ModEffects.EXTRACTED, maxInt));
        return new Pair((Object)new PotionContents(Optional.of(Potions.WATER), Optional.of(PotionContents.getColor(ret)), ret), ret);
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new RebrewingStandMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    public int getContainerSize() {
        return 6;
    }

    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.inv.size() ? (ItemStack)this.inv.get(slot) : ItemStack.EMPTY;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inv;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.inv = nonNullList;
    }

    public ItemStack removeItem(int slot, int pAmount) {
        return ContainerHelper.removeItem(this.inv, (int)slot, (int)pAmount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inv, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inv.size()) {
            this.inv.set(slot, (Object)stack);
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inv.clear();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inv, (HolderLookup.Provider)registries);
        tag.putByte("progress", (byte)this.brewProgress);
        tag.putByte("fuel", (byte)this.fuel);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inv = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inv, (HolderLookup.Provider)registries);
        this.fuel = tag.getByte("fuel");
        this.brewProgress = tag.getByte("progress");
    }

    public static void addPotionListToStack(List<MobEffectInstance> list, ItemStack itemStack) {
        itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.of(Potions.WATER), Optional.of(PotionContents.getColor(list)), list));
    }
}

