/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blockentities.BerootCauldronBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import org.jetbrains.annotations.Nullable;

public class BerootCauldronBlock
extends AbstractMultiBlock
implements ModEntityBlock,
IPreviewableMultiblock {
    public static final VoxelShape SHAPE_UPPER = BerootCauldronBlock.makeShapeUpper();
    public static final VoxelShape SHAPE_LOWER = BerootCauldronBlock.makeShapeLower();
    public static final VoxelShape SHAPE_LOWER_ROTATED = BerootCauldronBlock.makeShapeLowerRotated();
    public static final VoxelShape SHAPE_INSIDE = Shapes.box((double)-0.75, (double)0.5625, (double)-0.875, (double)0.75, (double)1.0, (double)0.625);
    public static final VoxelShape SHAPE_FULL = Shapes.box((double)-0.875, (double)0.5, (double)-1.0, (double)0.875, (double)1.6875, (double)0.75);

    public BerootCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getMultiblockRenderShape(BlockState state) {
        if (IMultiBlock.isCenter((BlockState)state)) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.INVISIBLE;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public DirectionProperty getDirectionProperty() {
        return HorizontalDirectionalBlock.FACING;
    }

    public Stream<BlockPos> fullBlockShape(Direction direction, BlockPos center) {
        BlockPos relative = center.relative(direction).relative(direction.getClockWise()).above();
        return BlockPos.betweenClosedStream((AABB)new AABB(center.getCenter(), relative.getCenter()));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack item = player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockEntity blockEntity = level.getBlockEntity(IMultiBlock.getCenter((BlockGetter)level, (BlockPos)pos));
        if (blockEntity instanceof BerootCauldronBlockEntity) {
            BerootCauldronBlockEntity blockEntity2 = (BerootCauldronBlockEntity)blockEntity;
            return blockEntity2.addItem(item, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BerootCauldronBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return this.tickerHelper(level);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE_UPPER;
        if (IMultiBlock.getYOffset((BlockGetter)getter, (BlockPos)pos) <= 0) {
            shape = ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis().equals((Object)Direction.Axis.X) ? SHAPE_LOWER_ROTATED : SHAPE_LOWER;
        }
        return this.voxelShapeHelper(state, getter, pos, shape, 0.0f, 0.0f, 1.125f, true);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.voxelShapeHelper(state, getter, pos, SHAPE_FULL, 0.0f, 0.0f, 1.125f, true);
    }

    public static VoxelShape makeShapeUpper() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.875, (double)0.5, (double)-1.0, (double)0.875, (double)1.6875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.75, (double)0.5625, (double)-0.875, (double)0.75, (double)1.6875, (double)0.625), (BooleanOp)BooleanOp.ONLY_FIRST);
        return shape.optimize();
    }

    public static VoxelShape makeShapeLower() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)0.0, (double)-0.5, (double)1.0, (double)0.6875, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.875, (double)0.5, (double)-1.0, (double)0.875, (double)1.6875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.75, (double)0.5625, (double)-0.875, (double)0.75, (double)1.6875, (double)0.625), (BooleanOp)BooleanOp.ONLY_FIRST);
        return shape.optimize();
    }

    public static VoxelShape makeShapeLowerRotated() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.375, (double)0.0, (double)-1.125, (double)0.375, (double)0.6875, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.875, (double)0.5, (double)-1.0, (double)0.875, (double)1.6875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.75, (double)0.5625, (double)-0.875, (double)0.75, (double)1.6875, (double)0.625), (BooleanOp)BooleanOp.ONLY_FIRST);
        return shape.optimize();
    }
}

