/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.ArrayList;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blockentities.BondripiaBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Bonmeelable;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.GiantCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.multiblock.ICorruptableMultiblock;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import org.jetbrains.annotations.Nullable;

public class BondripiaBlock
extends AbstractMultiBlock
implements EntityBlock,
ModCropBlock,
Corruptable,
IPreviewableMultiblock,
ICorruptableMultiblock {
    private static final VoxelShape SHAPE = BondripiaBlock.makeShape();

    public BondripiaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Block getCuredBlock() {
        return (Block)ModBlocks.BONDRIPIA.get();
    }

    @Override
    public Block getCorruptedBlock() {
        return (Block)ModBlocks.ACIDRIPIA.get();
    }

    public BlockState getDefaultStateForPreviews(Direction direction) {
        return (BlockState)super.getDefaultStateForPreviews(direction).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge()));
    }

    public RenderShape getMultiblockRenderShape(BlockState blockState) {
        if (!IMultiBlock.isCenter((BlockState)blockState)) {
            return RenderShape.INVISIBLE;
        }
        if (this.getAge(blockState) == this.getMaxAge()) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getAgeProperty(), ModStateProperties.SHEARED});
    }

    public Stream<BlockPos> fullBlockShape(@Nullable Direction direction, BlockPos center) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(center.immutable());
        positions.addAll(Direction.Plane.HORIZONTAL.stream().map(direction1 -> center.relative(direction1).immutable()).toList());
        return positions.stream();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        this.spawnBonmeeliaParticles(state, level, pos, random);
    }

    private void spawnBonmeeliaParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        boolean isAcidripia = state.is((Block)ModBlocks.ACIDRIPIA.get());
        if (IMultiBlock.isCenter((BlockState)state) && this.isMaxAge(state) && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            if ((double)random.nextFloat() < 0.4) {
                BlockPos.withinManhattanStream((BlockPos)entity.getCenter(), (int)1, (int)0, (int)1).forEach(blockPos -> {
                    SimpleParticleType fallParticles;
                    Vec3 vec3 = blockPos.getCenter();
                    BlockPos difference = blockPos.subtract((Vec3i)entity.getCenter());
                    boolean isCorner = Math.abs(difference.getX()) + Math.abs(difference.getZ()) == 2;
                    boolean isMid = blockPos.equals((Object)entity.getCenter());
                    BlockPos pos2 = blockPos.below(random.nextInt(8));
                    SimpleParticleType dripParticles = isAcidripia ? (SimpleParticleType)ModParticles.ACIDRIPIA_DRIP.get() : (SimpleParticleType)ModParticles.BONDRIPIA_DRIP.get();
                    SimpleParticleType simpleParticleType = fallParticles = isAcidripia ? (SimpleParticleType)ModParticles.ACIDRIPIA_FALL.get() : (SimpleParticleType)ModParticles.BONDRIPIA_FALL.get();
                    if ((double)random.nextFloat() < 0.5) {
                        if (isMid) {
                            level.addParticle((ParticleOptions)dripParticles, vec3.x + (double)random.nextIntBetweenInclusive(-1, 1) * 0.15, vec3.y - 0.25, vec3.z + (double)random.nextIntBetweenInclusive(-1, 1) * 0.15, 0.0, 1.0, 0.0);
                        } else if (isCorner) {
                            level.addParticle((ParticleOptions)fallParticles, vec3.x - (double)difference.getX() * 0.05, vec3.y, vec3.z - (double)difference.getZ() * 0.05, 0.0, 1.0, 0.0);
                        } else {
                            level.addParticle((ParticleOptions)dripParticles, vec3.x - (double)difference.getX() * 0.1, vec3.y, vec3.z - (double)difference.getZ() * 0.1, 0.0, 1.0, 0.0);
                        }
                    }
                    if (!level.getBlockState(pos2).canBeReplaced() && level.getBlockState(pos2.below()).isAir()) {
                        ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos2, (RandomSource)random, (ParticleOptions)dripParticles);
                    }
                });
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Object object;
        if (((Boolean)state.getValue((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        if (!this.isMaxAge(state) && IMultiBlock.isCenter((BlockState)state)) {
            this.grow((Level)level, pos, state);
        } else if (random.nextDouble() <= 0.33 && (object = level.getBlockEntity(pos)) instanceof BondripiaBlockEntity) {
            BondripiaBlockEntity entity = (BondripiaBlockEntity)((Object)object);
            object = BlockPos.betweenClosed((BlockPos)entity.center.below().north().east(), (BlockPos)entity.center.below().south().west()).iterator();
            while (object.hasNext()) {
                BlockPos blockPos;
                BlockPos currentPos = blockPos = (BlockPos)object.next();
                int y = level.getRandom().nextIntBetweenInclusive(1, 11);
                if (this.isBondripable((Level)level, currentPos = currentPos.below(y))) {
                    Bonmeelable bonmeelable;
                    BonemealableBlock bonemealable;
                    BlockState blockState = level.getBlockState(currentPos);
                    Block block = blockState.getBlock();
                    if (block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, currentPos, blockState)) {
                        bonemealable.performBonemeal(level, random, currentPos, blockState);
                        break;
                    }
                    if (!blockState.is(ModTags.ModBlockTags.BONMEELABLE) || !(bonmeelable = (Bonmeelable)GiantCropBlock.getCropMap().get(blockState.getBlock()).getA()).canBonmeel(currentPos, blockState, (Level)level)) continue;
                    bonmeelable.performBonmeel(currentPos, blockState, (Level)level, null);
                    break;
                }
                Block block = level.getBlockState(currentPos).getBlock();
                if (!(block instanceof AbstractCauldronBlock)) continue;
                AbstractCauldronBlock block2 = (AbstractCauldronBlock)block;
                this.fillCauldron((Level)level, currentPos, level.getBlockState(currentPos));
            }
        }
    }

    public void fillCauldron(Level level, BlockPos blockPos, BlockState blockState) {
        BlockState blockstate = blockState.is((Block)ModBlocks.ACIDRIPIA.get()) ? ((Block)ModBlocks.ACID_FILLED_CAULDRON.get()).defaultBlockState() : ((Block)ModBlocks.BONMEEL_FILLED_CAULDRON.get()).defaultBlockState();
        int fluidLevel = level.getBlockState(blockPos).getOptionalValue((Property)LayeredCauldronBlock.LEVEL).orElse(0);
        if (fluidLevel < 3) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockstate.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(fluidLevel + 1)));
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)blockstate));
            level.levelEvent(1047, blockPos, 0);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityinside) {
        this.corruptionHelper(state, level, pos, entityinside);
    }

    public void grow(Level level, BlockPos blockPos, BlockState state) {
        this.growHelper(level, blockPos, this.getAgeProperty());
    }

    private boolean isBondripable(Level level, BlockPos blockPos) {
        return level.getBlockState(blockPos).getBlock() instanceof BonemealableBlock || level.getBlockState(blockPos).is(ModTags.ModBlockTags.BONMEELABLE);
    }

    public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN) && !level.isWaterAt(pos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BondripiaBlockEntity(pos, state);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.grow((Level)level, pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.voxelShapeHelper(state, getter, pos, SHAPE);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.6875, (double)0.875, (double)0.0, (double)1.6875, (double)1.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)-0.6875, (double)1.0, (double)1.0625, (double)1.6875), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

