/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.Optional;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface Corruptable {
    default public Optional<Block> getCorruptedBlock(Block block, RandomSource random) {
        return net.abraxator.moresnifferflowers.data.datamaps.Corruptable.getCorruptedBlock(block, random);
    }

    default public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        BlockState corruptedState = corruptedBlock.withPropertiesOf(oldState);
        level.setBlockAndUpdate(pos, corruptedState);
    }

    default public void onCorruptByEntity(Entity entity, BlockPos blockPos, BlockState blockState, Block block, Level level) {
        if (entity instanceof CorruptedProjectile) {
            CorruptedProjectile corruptedProjectile = (CorruptedProjectile)entity;
            if (net.abraxator.moresnifferflowers.data.datamaps.Corruptable.canBeCorrupted(block, level)) {
                this.onCorrupt(level, blockPos, blockState, this.getCorruptedBlock(block, level.random).get());
                corruptedProjectile.remove(Entity.RemovalReason.DISCARDED);
                if (level.isClientSide) {
                    level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)3549245).toVector3f(), 1.0f), entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

