/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DawnberryVineBlock
extends MultifaceBlock
implements BonemealableBlock,
ModCropBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final BooleanProperty SHEARED = ModStateProperties.SHEARED;
    public static final MapCodec<DawnberryVineBlock> CODEC = RecordCodecBuilder.mapCodec(p_304392_ -> p_304392_.group((App)DawnberryVineBlock.propertiesCodec(), (App)Codec.BOOL.fieldOf("evil").forGetter(DawnberryVineBlock::isEvil)).apply((Applicative)p_304392_, DawnberryVineBlock::new));
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);
    private final boolean evil;

    public DawnberryVineBlock(BlockBehaviour.Properties properties, boolean evil) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SHEARED, (Comparable)Boolean.FALSE));
        this.evil = evil;
    }

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE, SHEARED});
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    public int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    @Override
    public int getMaxAge() {
        return (Integer)AGE.getPossibleValues().stream().toList().get(AGE.getPossibleValues().size() - 1);
    }

    @Override
    public final boolean isMaxAge(BlockState state) {
        return this.getAge(state) >= this.getMaxAge();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state) && (Boolean)state.getValue((Property)SHEARED) == false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.shear(player, level, pos, hand)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Items.BONE_MEAL) && this.getAge(state) < 4) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.isMaxAge(state)) {
            return this.dropMaxAgeLoot(state, level, pos, player);
        }
        if ((Integer)state.getValue((Property)AGE) == 3) {
            return this.dropAgeThreeLoot(state, level, pos, player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult dropMaxAgeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        RandomSource randomSource = level.getRandom();
        ItemStack DAWNBERRY = new ItemStack(this.evil ? (ItemLike)ModItems.GLOOMBERRY.get() : (ItemLike)ModItems.DAWNBERRY.get(), randomSource.nextIntBetweenInclusive(1, 2));
        DawnberryVineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        BlockState state = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(2));
        level.setBlock(pos, state, 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult dropAgeThreeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        RandomSource randomSource = level.getRandom();
        ItemStack DAWNBERRY = new ItemStack(this.evil ? (ItemLike)ModItems.GLOOMBERRY.get() : (ItemLike)ModItems.DAWNBERRY.get(), randomSource.nextIntBetweenInclusive(1, 2));
        DawnberryVineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        BlockState state = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(2));
        level.setBlock(pos, state, 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9) {
            this.makeGrowOnTick(state, (Level)level, pos);
        }
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = this.getAge(state);
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age >= 4 ? age : age + 1)), 2);
        boolean canSpread = Direction.stream().anyMatch(p_153316_ -> this.spreader.canSpreadInAnyDirection(state, (BlockGetter)level, pos, p_153316_.getOpposite()));
        if (random.nextFloat() >= 0.3f && random.nextFloat() >= 0.3f && canSpread) {
            this.getSpreader().spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, random);
            this.getSpreader().spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, random);
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean isEvil() {
        return this.evil;
    }
}

