/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DripsaltBlock
extends PointedDripstoneBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public DripsaltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)ModItems.SALTY_SPICE.get()) && stack.getCount() >= 5) {
            for (int i = 0; i < 5; ++i) {
                if (!level.getBlockState(pos.above(i + 1)).isAir() || !level.getBlockState(pos.above(i)).is((Block)this)) continue;
                level.setBlock(pos.above(i + 1), this.defaultBlockState(), 3);
                if (!player.isCreative()) {
                    stack.shrink(5);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return DripsaltBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    public BlockState updateShape(BlockState state, Direction p_direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (p_direction != Direction.UP && p_direction != Direction.DOWN) {
            return state;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            return state;
        }
        if (p_direction == direction.getOpposite() && !this.canSurvive(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN) {
                level.scheduleTick(pos, (Block)this, 2);
            } else {
                level.scheduleTick(pos, (Block)this, 1);
            }
            return state;
        }
        boolean flag = state.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = DripsaltBlock.calculateDripstoneThickness((LevelReader)level, pos, direction, flag);
        return (BlockState)state.setValue(THICKNESS, (Comparable)dripstonethickness);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, blockpos) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(blockpos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float f;
        if (DripsaltBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            DripsaltBlock.getFluidAboveStalactite(level, pos, state).filter(p_221848_ -> f < 0.02f || DripsaltBlock.canFillCauldron(p_221848_.fluid)).ifPresent(p_221881_ -> DripsaltBlock.spawnDripParticle(level, pos, state, p_221881_.fluid));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (DripsaltBlock.isStalagmite(state) && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        } else {
            DripsaltBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        DripsaltBlock.maybeTransferFluid(state, level, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && DripsaltBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            DripsaltBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @VisibleForTesting
    public static void maybeTransferFluid(BlockState state, ServerLevel level, BlockPos pos, float randChance) {
        Optional<FluidInfo> optional;
        if (!(randChance > 0.17578125f && randChance > 0.05859375f || !DripsaltBlock.isStalactiteStartPos(state, (LevelReader)level, pos) || (optional = DripsaltBlock.getFluidAboveStalactite((Level)level, pos, state)).isEmpty())) {
            BlockPos blockpos;
            float f;
            Fluid fluid = optional.get().fluid;
            if (fluid == Fluids.WATER) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.LAVA) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(randChance >= f) && (blockpos = DripsaltBlock.findTip(state, (LevelAccessor)level, pos, 11, false)) != null) {
                if (optional.get().sourceState.is(Blocks.MUD) && fluid == Fluids.WATER) {
                    BlockState blockstate1 = Blocks.CLAY.defaultBlockState();
                    level.setBlockAndUpdate(optional.get().pos, blockstate1);
                    Block.pushEntitiesUp((BlockState)optional.get().sourceState, (BlockState)blockstate1, (LevelAccessor)level, (BlockPos)optional.get().pos);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, optional.get().pos, GameEvent.Context.of((BlockState)blockstate1));
                    level.levelEvent(1504, blockpos, 0);
                } else {
                    BlockPos blockpos1 = DripsaltBlock.findFillableCauldronBelowStalactiteTip((Level)level, blockpos, fluid);
                    if (blockpos1 != null) {
                        level.levelEvent(1504, blockpos, 0);
                        int i = blockpos.getY() - blockpos1.getY();
                        int j = 50 + i;
                        BlockState blockstate = level.getBlockState(blockpos1);
                        level.scheduleTick(blockpos1, blockstate.getBlock(), j);
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        Direction direction1 = DripsaltBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = context.getClickedPos(), direction = context.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = DripsaltBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue(THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.getOffset(level, pos);
        return voxelshape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1045, pos, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingStalactite(entity);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockState blockstate = state;
        while (DripsaltBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (DripsaltBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = level.getBlockState(pos.above(1));
        if (DripsaltBlock.canGrow(blockstate, blockstate1 = level.getBlockState(pos.above(2))) && (blockpos = DripsaltBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && DripsaltBlock.canDrip(blockstate2 = level.getBlockState(blockpos)) && DripsaltBlock.canTipGrow(blockstate2, level, blockpos)) {
            if (random.nextBoolean()) {
                DripsaltBlock.grow(level, blockpos, Direction.DOWN);
            } else {
                DripsaltBlock.growStalagmiteBelow(level, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (DripsaltBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && DripsaltBlock.canTipGrow(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                DripsaltBlock.grow(level, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (DripsaltBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)blockpos$mutableblockpos, Direction.UP) && !level.isWaterAt(blockpos$mutableblockpos.below())) {
                DripsaltBlock.grow(level, blockpos$mutableblockpos.below(), Direction.UP);
                return;
            }
            if (DripsaltBlock.canDripThrough((BlockGetter)level, (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void grow(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = server.getBlockState(blockpos);
        if (DripsaltBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite())) {
            DripsaltBlock.createMergedTips(blockstate, (LevelAccessor)server, blockpos);
        } else if (blockstate.isAir() || blockstate.is(Blocks.WATER)) {
            DripsaltBlock.createDripstone((LevelAccessor)server, blockpos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.DRIPSALT.get()).defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        level.setBlock(pos, blockstate, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = pos;
            blockpos = pos.above();
        } else {
            blockpos = pos;
            blockpos1 = pos.below();
        }
        DripsaltBlock.createDripstone(level, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        DripsaltBlock.createDripstone(level, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void spawnDripParticle(Level level, BlockPos pos, BlockState state) {
        DripsaltBlock.getFluidAboveStalactite(level, pos, state).ifPresent(p_221856_ -> DripsaltBlock.spawnDripParticle(level, pos, state, p_221856_.fluid));
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid p_fluid) {
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        double d0 = 0.0625;
        double d1 = (double)pos.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.getZ() + 0.5 + vec3.z;
        Fluid fluid = DripsaltBlock.getDripFluid(level, p_fluid);
        SimpleParticleType particleoptions = fluid.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        level.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (DripsaltBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.is((Block)ModBlocks.DRIPSALT.get()) && p_202024_.getValue((Property)TIP_DIRECTION) == direction;
        return DripsaltBlock.findBlockVertical(level, pos, direction.getAxisDirection(), bipredicate, p_154168_ -> DripsaltBlock.isTip(p_154168_, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (DripsaltBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!DripsaltBlock.isValidPointedDripstonePlacement(level, pos, dir.getOpposite())) {
                return null;
            }
            direction = dir.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.getOpposite();
        BlockState blockstate = level.getBlockState(pos.relative(dir));
        if (DripsaltBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !isTipMerge && blockstate.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!DripsaltBlock.isPointedDripstoneWithDirection(blockstate, dir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = level.getBlockState(pos.relative(direction));
            return !DripsaltBlock.isPointedDripstoneWithDirection(blockstate1, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return DripsaltBlock.isStalactite(state) && state.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos blockpos = pos.relative(direction);
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() ? true : DripsaltBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state, int maxIterations) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202015_, p_202016_) -> p_202016_.is((Block)ModBlocks.DRIPSALT.get()) && p_202016_.getValue((Property)TIP_DIRECTION) == direction;
        return DripsaltBlock.findBlockVertical((LevelAccessor)level, pos, direction.getOpposite().getAxisDirection(), bipredicate, p_154245_ -> !p_154245_.is((Block)ModBlocks.DRIPSALT.get()), maxIterations);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.relative(dir.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, dir) || DripsaltBlock.isPointedDripstoneWithDirection(blockstate, dir);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!state.is((Block)ModBlocks.DRIPSALT.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || isTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction dir) {
        return DripsaltBlock.isTip(state, false) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(BlockState state) {
        return DripsaltBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return DripsaltBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return DripsaltBlock.isStalactite(state) && !level.getBlockState(pos.above()).is((Block)ModBlocks.DRIPSALT.get());
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.is((Block)ModBlocks.DRIPSALT.get()) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level level, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = p_154162_ -> p_154162_.getBlock() instanceof AbstractCauldronBlock;
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202034_, p_202035_) -> DripsaltBlock.canDripThrough((BlockGetter)level, p_202034_, p_202035_);
        return DripsaltBlock.findBlockVertical((LevelAccessor)level, pos, Direction.DOWN.getAxisDirection(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(Level level, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202030_, p_202031_) -> DripsaltBlock.canDripThrough((BlockGetter)level, p_202030_, p_202031_);
        return DripsaltBlock.findBlockVertical((LevelAccessor)level, pos, Direction.UP.getAxisDirection(), bipredicate, PointedDripstoneBlock::canDrip, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(ServerLevel level, BlockPos pos) {
        return DripsaltBlock.getFluidAboveStalactite((Level)level, pos, level.getBlockState(pos)).map(p_221858_ -> p_221858_.fluid).filter(DripsaltBlock::canFillCauldron).orElse(Fluids.EMPTY);
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !DripsaltBlock.isStalactite(state) ? Optional.empty() : DripsaltBlock.findRootBlock(level, pos, state, 11).map(p_221876_ -> {
            BlockPos blockpos = p_221876_.above();
            BlockState blockstate = level.getBlockState(blockpos);
            Object fluid = blockstate.is(Blocks.MUD) && !level.dimensionType().ultraWarm() ? Fluids.WATER : level.getFluidState(blockpos).getType();
            return new FluidInfo(blockpos, (Fluid)fluid, blockstate);
        });
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.LAVA || fluid == Fluids.WATER;
    }

    private static boolean canGrow(BlockState dripstoneState, BlockState state) {
        return dripstoneState.is(Blocks.DRIPSTONE_BLOCK) && state.is(Blocks.WATER) && state.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level level, Fluid fluid) {
        if (fluid.isSame(Fluids.EMPTY)) {
            return level.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.get((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (int i = 1; i < maxIterations; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!level.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && positionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender(level, pos)) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = state.getCollisionShape(level, pos);
        return !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

