/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.mojang.serialization.MapCodec;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DyespriaPlantBlock
extends BushBlock
implements ModCropBlock,
ModEntityBlock,
Corruptable {
    public static final MapCodec<DyespriaPlantBlock> CODEC = DyespriaPlantBlock.simpleCodec(DyespriaPlantBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public DyespriaPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false))).setValue(ModStateProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getAgeProperty()}).add(new Property[]{ModStateProperties.COLOR}).add(new Property[]{ModStateProperties.SHEARED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity pPlacer, ItemStack stack) {
        if (pPlacer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlacer;
            ((SimpleAdvancementTrigger)((Object)ModAdvancementCritters.PLACED_DYESPRIA_PLANT.get())).trigger(serverPlayer);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (this.shear(player, level, pos, hand)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.isMaxAge(state) && (blockEntity = level.getBlockEntity(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (stack.getItem() instanceof DyeItem) {
                return this.addDye(stack, player, level, entity);
            }
            if (this.shear(player, level, pos, hand)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (this.isMaxAge(state) && (blockEntity = level.getBlockEntity(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            player.addItem(Dye.stackFromDye(entity.removeDye()));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    private ItemInteractionResult addDye(ItemStack dye, Player player, Level level, DyespriaPlantBlockEntity entity) {
        if (!level.isClientSide) {
            ItemStack stack = dye.copy();
            dye.setCount(-1);
            player.addItem(entity.add(null, entity.dye, stack));
        }
        level.playSound(null, entity.getBlockPos(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, (float)(1.0 + (double)level.random.nextFloat() * 0.2));
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public BlockState updateShape(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.canSurvive(state, (LevelReader)level, pCurrentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.getBlockState(pos.below()));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (!pNewState.is((Block)ModBlocks.DYESCRAPIA_PLANT.get()) && !state.is(pNewState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (this.isMaxAge(state)) {
                ItemStack dyespria = ((Item)ModItems.DYESPRIA.get()).getDefaultInstance();
                dyespria.set(ModDataComponents.AMOUNT, (Object)entity.dye.amount());
                dyespria.set(ModDataComponents.COLOR_ID, (Object)entity.dye.colorId());
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)dyespria);
            }
        }
        super.onRemove(state, level, pos, pNewState, pMovedByPiston);
    }

    @Override
    public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (this.isMaxAge(oldState)) {
                ItemStack dye = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)entity.dye.color()), entity.dye.amount());
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)dye);
            }
        }
        Corruptable.super.onCorrupt(level, pos, oldState, corruptedBlock);
    }

    @Override
    public boolean mayPlaceOn(BlockState state) {
        return state.is(BlockTags.DIRT) && !(state.getBlock() instanceof FarmBlock);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_3;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.isMaxAge(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.makeGrowOnTick(state, (Level)level, pos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.makeGrowOnBonemeal((Level)level, pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() && this.isMaxAge(state) && (blockEntity = level.getBlockEntity(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            ItemStack stack = ModItems.DYESPRIA.toStack();
            stack.set(ModDataComponents.DYE, (Object)entity.dye);
            return stack;
        }
        return ModItems.DYESPRIA_SEEDS.toStack();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DyespriaPlantBlockEntity(pos, state);
    }
}

