/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blocks.CaulorflowerBlock;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PatternflowerBlock
extends CaulorflowerBlock
implements BonemealableBlock,
ModCropBlock {
    public PatternflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ModStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(true))).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue(ModStateProperties.BLOCK_PATTERN, (Comparable)((Object)BlockPattern.EMPTY))).setValue((Property)ModStateProperties.EMPTY, (Comparable)Boolean.valueOf(true))).setValue((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canBeColored(BlockState blockState, Dye dye) {
        return false;
    }

    @Override
    public boolean isCorrupted() {
        return true;
    }

    @Override
    public void popResource(Level level, BlockPos pos, BlockState state) {
        PatternflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)BlockPattern.fromState(state).getItem().getDefaultInstance());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ModStateProperties.FACING, ModStateProperties.SHEARED, ModStateProperties.FLIPPED, this.getAgeProperty(), ModStateProperties.BLOCK_PATTERN, ModStateProperties.EMPTY});
    }

    @Override
    public BlockState updateShape(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (this.canSurvive(state, (LevelReader)level, pCurrentPos)) {
            return (BlockState)((BlockState)state.setValue((Property)ModStateProperties.FLIPPED, (Comparable)Boolean.valueOf(pCurrentPos.getY() % 2 == 0))).setValue((Property)ModStateProperties.EMPTY, (Comparable)Boolean.valueOf(BlockPattern.isEmpty(state)));
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return BlockPattern.fromState(state).isBanner() ? (double)random.nextFloat() < 0.2 : (double)random.nextFloat() < 0.5;
    }

    @Override
    public boolean harvestable(BlockState blockState) {
        return this.isMaxAge(blockState) && !BlockPattern.isEmpty(blockState);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.is((Block)this)) {
            return;
        }
        BlockState stateBelow = level.getBlockState(pos.below());
        if (!stateBelow.is((Block)this) && !stateBelow.is(Blocks.AIR)) {
            PatternflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.PATTERNFLOWER_SEEDS.get()));
        }
        if (!BlockPattern.isEmpty(state) && this.isMaxAge(state)) {
            PatternflowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)BlockPattern.fromState(state).getItem().getDefaultInstance());
        }
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }
}

