/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.mojang.serialization.MapCodec;
import net.abraxator.moresnifferflowers.blockentities.TorchflowerBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TorchflowerAflameBlock
extends BushBlock
implements EntityBlock,
ModCropBlock {
    public static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    public static final MapCodec<TorchflowerAflameBlock> CODEC = TorchflowerAflameBlock.simpleCodec(TorchflowerAflameBlock::new);

    public TorchflowerAflameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getAgeProperty()}).add(new Property[]{ModStateProperties.FIRE_TICKS});
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (this.getAge(state) == this.getMaxAge()) {
            TorchflowerAflameBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)((Item)ModItems.FIERY_SPICE.get()).getDefaultInstance());
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide) {
            return;
        }
        super.animateTick(state, level, pos, random);
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        Vec3 offset = new Vec3((double)pos.getX() + vec3.x, (double)pos.getY() + vec3.y, (double)pos.getZ() + vec3.z);
        Vec3 center = pos.getCenter().add(vec3);
        if (this.getAge(state) == 1) {
            if (random.nextInt(24) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int j1 = 0; j1 < 2; ++j1) {
                if (!(random.nextFloat() < 0.6f)) continue;
                double d7 = offset.x + random.nextDouble();
                double d12 = offset.y + 1.0 - random.nextDouble() * (double)0.1f;
                double d17 = offset.z + random.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
            }
            if (random.nextFloat() < 0.3f) {
                double d1 = center.x + random.nextDouble() / 3.0;
                double d2 = center.y + 0.7 - random.nextDouble() / 2.0;
                double d3 = center.z + random.nextDouble() / 3.0;
                Particle particle = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ModParticles.TORCHFLAME.get(), d1, d2, d3, 0.0, 0.0, 0.0);
                if (particle != null) {
                    particle.scale(0.5f + random.nextFloat());
                }
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        int age = this.getAge(state);
        return age == 0 || age == 1;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = this.getAge(state);
        if (age == 0 && TorchflowerAflameBlock.isBonemealSuccess((Level)level)) {
            level.setBlockAndUpdate(pos, Blocks.TORCHFLOWER.defaultBlockState());
        }
        if (age == 1 && (!level.getBlockState(pos.below(2)).is(Blocks.NETHERRACK) || level.isRainingAt(pos))) {
            int fire = (Integer)state.getValue((Property)ModStateProperties.FIRE_TICKS);
            if (fire < 5 && !level.isRainingAt(pos)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(fire + 1)));
            } else {
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(2)));
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        int age = this.getAge(state);
        if (age == 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int age = this.getAge(state);
        int fire = (Integer)state.getValue((Property)ModStateProperties.FIRE_TICKS);
        if (age == 0 && stack.is(Items.BONE_MEAL)) {
            if (TorchflowerAflameBlock.isBonemealSuccess(level)) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.performBonemeal(serverLevel, level.random, pos, state);
                }
            } else if (!player.isCreative()) {
                stack.shrink(1);
            }
            BoneMealItem.addGrowthParticles((LevelAccessor)level, (BlockPos)pos, (int)10);
            return ItemInteractionResult.SUCCESS;
        }
        if (age == 1 && ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER)) {
            RandomSource random = level.getRandom();
            for (int j1 = 0; j1 < (fire + 1) * 2; ++j1) {
                Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
                Vec3 center = pos.getCenter().add(vec3);
                double d7 = center.x + random.nextDouble() - 0.5;
                double d12 = center.y - random.nextDouble() + 0.5;
                double d17 = center.z + random.nextDouble() - 0.5;
                level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 2.0f), d7, d12, d17, 0.0, 0.0, 0.0);
            }
            if (!player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            if (fire < 5) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ModStateProperties.FIRE_TICKS, (Comparable)Integer.valueOf(fire + 1)));
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
            } else {
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(2)));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static boolean isBonemealSuccess(Level level) {
        return level.random.nextFloat() < 0.3f;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TorchflowerBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.getAge(state) == 0;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return TorchflowerAflameBlock.isBonemealSuccess(level);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, Blocks.TORCHFLOWER.defaultBlockState());
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }
}

