/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.rebrewingstand;

import net.abraxator.moresnifferflowers.blockentities.RebrewingStandBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModEntityDoubleTallBlock;
import net.abraxator.moresnifferflowers.blocks.rebrewingstand.RebrewingStandBlockTop;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RebrewingStandBlockBase
extends ModEntityDoubleTallBlock {
    public static final BooleanProperty[] HAS_BOTTLE = new BooleanProperty[]{BlockStateProperties.HAS_BOTTLE_0, BlockStateProperties.HAS_BOTTLE_1, BlockStateProperties.HAS_BOTTLE_2};
    public static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static VoxelShape ROD_UPPER = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)14.0, (double)9.5);
    public static VoxelShape ROD_LOWER = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);

    public RebrewingStandBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
        if (!(this instanceof RebrewingStandBlockTop)) {
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_BOTTLE[0], (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOTTLE[1], (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOTTLE[2], (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add((Property[])HAS_BOTTLE);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)BASE, (VoxelShape)ROD_LOWER);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity entity;
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = pos;
        if (level.getBlockState(pos).is((Block)ModBlocks.REBREWING_STAND_BOTTOM.get())) {
            blockPos = blockPos.above();
        }
        if ((entity = level.getBlockEntity(blockPos)) instanceof RebrewingStandBlockEntity) {
            player.openMenu((MenuProvider)((RebrewingStandBlockEntity)entity));
        }
        return InteractionResult.CONSUME;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.getX() + 0.4 + (double)random.nextFloat() * 0.2;
        double d1 = (double)pos.getY() + 0.7 + (double)random.nextFloat() * 0.3;
        double d2 = (double)pos.getZ() + 0.4 + (double)random.nextFloat() * 0.2;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ModItems.REBREWING_STAND.toStack();
    }

    @Override
    public Block getLowerBlock() {
        return (Block)ModBlocks.REBREWING_STAND_BOTTOM.get();
    }

    @Override
    public Block getCorruptedLowerBlock() {
        return null;
    }

    @Override
    public Block getUpperBlock() {
        return (Block)ModBlocks.REBREWING_STAND_TOP.get();
    }

    @Override
    public Block getCorruptedUpperBlock() {
        return null;
    }

    @Override
    public boolean isLower(BlockState blockState) {
        return blockState.is((Block)ModBlocks.REBREWING_STAND_BOTTOM.get());
    }

    @Override
    public boolean isUpper(BlockState blockState) {
        return false;
    }
}

