/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.networking.toClient.SyncSlipperyPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class SlipperyCapability {
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("slippery");
    public float lastYaw = 0.0f;
    public float lastSpeed = 0.0f;
    public boolean isFallen = false;
    public int fallenTicks = 0;
    public int maxFallenTicks = 0;
    public static final Codec<SlipperyCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("lastYaw").forGetter(data -> Float.valueOf(data.lastYaw)), (App)Codec.FLOAT.fieldOf("lastSpeed").forGetter(data -> Float.valueOf(data.lastSpeed)), (App)Codec.BOOL.fieldOf("isFallen").forGetter(data -> data.isFallen), (App)Codec.INT.fieldOf("fallenTicks").forGetter(data -> data.fallenTicks), (App)Codec.INT.fieldOf("maxFallenTicks").forGetter(data -> data.maxFallenTicks)).apply((Applicative)instance, (a, b, c, d, e) -> {
        SlipperyCapability cap = new SlipperyCapability();
        cap.lastYaw = a.floatValue();
        cap.lastSpeed = b.floatValue();
        cap.isFallen = c;
        cap.fallenTicks = d;
        cap.maxFallenTicks = e;
        return cap;
    }));

    public void onEffectEnd(Player player) {
        this.lastSpeed = 0.0f;
        this.lastYaw = 0.0f;
        if (this.isFallen) {
            this.getUp(player);
        }
    }

    public void tick(Player player, int amplifier) {
        float yaw = player.getYRot();
        Vec3 motion = player.getDeltaMovement();
        float speed = (float)(motion.x + motion.y + motion.z);
        if (this.isFallen) {
            --this.fallenTicks;
            player.setJumping(false);
            player.setDeltaMovement(motion.x, Math.min(motion.y, 0.0), motion.z);
            if (!player.getPose().equals((Object)Pose.SWIMMING)) {
                player.setForcedPose(Pose.SWIMMING);
            }
            if (this.fallenTicks <= 0) {
                this.getUp(player);
            }
        } else if (!(player.level().isClientSide || this.lastSpeed == 0.0f && this.lastYaw == 0.0f)) {
            boolean rotationChange;
            boolean speedChange = Math.abs(speed - this.lastSpeed) > 0.6f;
            float rotationLimit = Math.max(90.0f - (float)(amplifier * 10), 15.0f);
            boolean bl = rotationChange = Math.abs(Mth.wrapDegrees((float)(yaw - this.lastYaw))) > rotationLimit && player.isSprinting();
            if (player.onGround() && (speedChange || rotationChange)) {
                this.fallDown(player, amplifier);
            }
        }
        this.lastSpeed = speed;
        this.lastYaw = yaw;
    }

    public void fallDown(Player player, int amplifier) {
        this.isFallen = true;
        this.fallenTicks = this.maxFallenTicks = 30 + amplifier * 10;
        player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(ID);
        AttributeModifier mod = new AttributeModifier(ID, -100.0, AttributeModifier.Operation.ADD_VALUE);
        player.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(mod);
        player.level().playSound(null, player.blockPosition(), SoundEvents.SLIME_SQUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.sync(player);
    }

    public void getUp(Player player) {
        this.fallenTicks = 0;
        this.isFallen = false;
        player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(ID);
        player.setForcedPose(null);
        if (!player.level().isClientSide) {
            this.sync(player);
        }
    }

    public void sync(Player player) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncSlipperyPacket(this, player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static SlipperyCapability get(Player player) {
        return (SlipperyCapability)player.getData(ModDataAttachments.SLIPPERY);
    }
}

