/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client;

import java.awt.Color;
import net.abraxator.moresnifferflowers.blocks.ColorableVivicusBlock;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="moresnifferflowers", value={Dist.CLIENT})
public class ModColorHandler {
    @SubscribeEvent
    public static void onRegisterBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, pTintIndex) -> {
            Colorable colorable = (Colorable)state.getBlock();
            Dye dye = colorable.getDyeFromBlock(state);
            int color = Dye.colorForDye(colorable, dye.color());
            if (!dye.isEmpty()) {
                if (pTintIndex == 0) {
                    float[] colorHSB = ModColorHandler.getColorHSB(color);
                    return Color.HSBtoRGB(colorHSB[0], Math.max(colorHSB[1] / 1.7f, 0.0f), Math.max(colorHSB[2], 0.0f));
                }
                if (pTintIndex == 1) {
                    return color;
                }
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.CAULORFLOWER.get()});
        event.register((state, level, pos, pTintIndex) -> {
            int color = ((BlockPattern)((Object)((Object)state.getValue(ModStateProperties.BLOCK_PATTERN)))).getColor();
            if (((Boolean)state.getValue((Property)ModStateProperties.EMPTY)).booleanValue()) {
                color = 0xFFFFFF;
            }
            if (pTintIndex == 0) {
                float[] colorHSB = ModColorHandler.getColorHSB(color);
                return Color.HSBtoRGB(colorHSB[0], Math.max(colorHSB[1] / 1.7f, 0.0f), Math.max(colorHSB[2], 0.0f));
            }
            if (pTintIndex == 1) {
                float[] colorHSB = ModColorHandler.getColorHSB(color);
                return Color.HSBtoRGB(colorHSB[0], Math.min(colorHSB[1] * 1.1f, 1.0f), Math.min(colorHSB[2] * 1.2f, 1.0f));
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.PATTERNFLOWER.get()});
        event.register((state, level, pos, pTintIndex) -> {
            ColorableVivicusBlock colorable = (ColorableVivicusBlock)state.getBlock();
            if (pTintIndex == 0) {
                int dyedValue = Dye.colorForDye(colorable, (DyeColor)state.getValue(colorable.getColorProperty()));
                if (state.is((Block)ModBlocks.VIVICUS_LEAVES.get()) || state.is((Block)ModBlocks.VIVICUS_LEAVES_SPROUT.get())) {
                    float[] colorHSB = ModColorHandler.getColorHSB(dyedValue);
                    if (pos == null) {
                        pos = new BlockPos(0, 0, 0);
                    }
                    float hue = colorHSB[0] + (1.0f + Mth.sin((float)((float)pos.getX() + (float)pos.getY() + (float)pos.getZ()))) / 15.0f;
                    if ((double)colorHSB[1] < 0.3 && (double)colorHSB[2] < 0.8) {
                        colorHSB[2] = colorHSB[2] - (1.0f + Mth.sin((float)((float)pos.getX() + (float)pos.getY() + (float)pos.getZ()))) / 15.0f;
                    }
                    if ((double)colorHSB[1] < 0.3) {
                        colorHSB[1] = colorHSB[1] + (1.0f + Mth.sin((float)((float)pos.getX() + (float)pos.getY() + (float)pos.getZ()))) / 12.0f;
                    }
                    return Color.HSBtoRGB(hue, colorHSB[1], colorHSB[2]);
                }
                return dyedValue;
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.VIVICUS_LOG.get(), (Block)ModBlocks.VIVICUS_WOOD.get(), (Block)ModBlocks.STRIPPED_VIVICUS_LOG.get(), (Block)ModBlocks.STRIPPED_VIVICUS_LOG.get(), (Block)ModBlocks.STRIPPED_VIVICUS_WOOD.get(), (Block)ModBlocks.VIVICUS_PLANKS.get(), (Block)ModBlocks.VIVICUS_STAIRS.get(), (Block)ModBlocks.VIVICUS_SLAB.get(), (Block)ModBlocks.VIVICUS_FENCE.get(), (Block)ModBlocks.VIVICUS_FENCE_GATE.get(), (Block)ModBlocks.VIVICUS_DOOR.get(), (Block)ModBlocks.VIVICUS_TRAPDOOR.get(), (Block)ModBlocks.VIVICUS_PRESSURE_PLATE.get(), (Block)ModBlocks.VIVICUS_BUTTON.get(), (Block)ModBlocks.VIVICUS_LEAVES.get(), (Block)ModBlocks.VIVICUS_SAPLING.get(), (Block)ModBlocks.VIVICUS_LEAVES_SPROUT.get(), (Block)ModBlocks.VIVICUS_SIGN.get(), (Block)ModBlocks.VIVICUS_HANGING_SIGN.get(), (Block)ModBlocks.VIVICUS_SAPLING.get()});
    }

    @SubscribeEvent
    public static void onRegisterItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, pTintIndex) -> {
            Dye dye = Dye.getDyeFromDyespria(stack);
            if (pTintIndex != 0 || dye.isEmpty()) {
                return -1;
            }
            return Dye.colorForDye((DyespriaItem)stack.getItem(), dye.color());
        }, new ItemLike[]{(ItemLike)ModItems.DYESPRIA.get()});
        event.register((stack, pTintIndex) -> pTintIndex > 0 ? -1 : ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor(), new ItemLike[]{(ItemLike)ModItems.EXTRACTED_BOTTLE.get(), (ItemLike)ModItems.REBREWED_POTION.get(), (ItemLike)ModItems.REBREWED_SPLASH_POTION.get(), (ItemLike)ModItems.REBREWED_LINGERING_POTION.get()});
        event.register((stack, tintIndex) -> {
            BlockPattern pattern = BlockPattern.fromPatternspria(stack);
            if (tintIndex != 0 || pattern == BlockPattern.EMPTY) {
                return -1;
            }
            return ModColorHandler.alphaFixer((Integer)stack.getOrDefault(ModDataComponents.COLOR.get(), (Object)pattern.getColor()));
        }, new ItemLike[]{(ItemLike)ModItems.PATTERNSPRIA.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            return ModColorHandler.alphaFixer((Integer)stack.getOrDefault(ModDataComponents.COLOR.get(), (Object)-1));
        }, new ItemLike[]{(ItemLike)ModBlocks.VIVICUS_LOG.get(), (ItemLike)ModBlocks.VIVICUS_WOOD.get(), (ItemLike)ModBlocks.STRIPPED_VIVICUS_LOG.get(), (ItemLike)ModBlocks.STRIPPED_VIVICUS_WOOD.get(), (ItemLike)ModBlocks.VIVICUS_PLANKS.get(), (ItemLike)ModBlocks.VIVICUS_STAIRS.get(), (ItemLike)ModBlocks.VIVICUS_SLAB.get(), (ItemLike)ModBlocks.VIVICUS_FENCE.get(), (ItemLike)ModBlocks.VIVICUS_FENCE_GATE.get(), (ItemLike)ModBlocks.VIVICUS_DOOR.get(), (ItemLike)ModBlocks.VIVICUS_TRAPDOOR.get(), (ItemLike)ModBlocks.VIVICUS_PRESSURE_PLATE.get(), (ItemLike)ModBlocks.VIVICUS_BUTTON.get(), (ItemLike)ModBlocks.VIVICUS_LEAVES.get(), (ItemLike)ModBlocks.VIVICUS_SAPLING.get(), (ItemLike)ModBlocks.VIVICUS_LEAVES_SPROUT.get(), (ItemLike)ModItems.VIVICUS_SIGN.get(), (ItemLike)ModItems.VIVICUS_HANGING_SIGN.get(), (ItemLike)ModItems.VIVICUS_BOAT.get(), (ItemLike)ModItems.VIVICUS_CHEST_BOAT.get(), (ItemLike)ModItems.ROOTED_SOUP.get()});
    }

    public static float @NotNull [] getColorHSB(int originalColor) {
        int startRed = originalColor >> 16 & 0xFF;
        int startGreen = originalColor >> 8 & 0xFF;
        int startBlue = originalColor & 0xFF;
        return Color.RGBtoHSB(startRed, startGreen, startBlue, null);
    }

    public static int[] hexToRGBLarge(int hex) {
        return new int[]{hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF};
    }

    public static float[] hexToRGB(int hex) {
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int[] argbToArray(int argb) {
        int r = FastColor.ARGB32.red((int)argb);
        int g = FastColor.ARGB32.green((int)argb);
        int b = FastColor.ARGB32.blue((int)argb);
        int a = FastColor.ARGB32.alpha((int)argb);
        return new int[]{r, g, b, a};
    }

    public static int alphaFixer(int color) {
        if (FastColor.ARGB32.alpha((int)color) < 1) {
            int[] rgb = ModColorHandler.hexToRGBLarge(color);
            return FastColor.ARGB32.color((int)rgb[0], (int)rgb[1], (int)rgb[2]);
        }
        return color;
    }

    public static int RGBtoInt(Vec3 color) {
        int r = (int)color.x;
        int g = (int)color.y;
        int b = (int)color.z;
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int barColorHelper(int input, int maxInput) {
        int lowColor = 0x8C1111;
        int highColor = 1545513;
        int lowRed = lowColor >> 16 & 0xFF;
        int lowGreen = lowColor >> 8 & 0xFF;
        int lowBlue = lowColor & 0xFF;
        int highRed = highColor >> 16 & 0xFF;
        int highGreen = highColor >> 8 & 0xFF;
        int highBlue = highColor & 0xFF;
        float[] lowHSB = Color.RGBtoHSB(lowRed, lowGreen, lowBlue, null);
        float[] highHSB = Color.RGBtoHSB(highRed, highGreen, highBlue, null);
        float finalHue = (lowHSB[0] * (float)Math.abs(input - maxInput) + highHSB[0] * (float)input) / (float)maxInput;
        return Mth.hsvToRgb((float)finalHue, (float)1.0f, (float)1.0f);
    }
}

