/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.menu;

import java.util.Optional;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModMenuTypes;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;

public class RebrewingStandMenu
extends AbstractContainerMenu {
    private final Container rebrewingStand;
    private final ContainerData rebrewingStandData;

    public RebrewingStandMenu(int id, Inventory playerInv) {
        this(id, playerInv, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(3));
    }

    public RebrewingStandMenu(int id, Inventory playerInv, Container rebrewingStandContainer, ContainerData rebrewingStandContainerData) {
        super((MenuType)ModMenuTypes.REBREWING_STAND.get(), id);
        RebrewingStandMenu.checkContainerSize((Container)rebrewingStandContainer, (int)6);
        RebrewingStandMenu.checkContainerDataCount((ContainerData)rebrewingStandContainerData, (int)2);
        this.rebrewingStand = rebrewingStandContainer;
        this.rebrewingStandData = rebrewingStandContainerData;
        this.addSlot(new FuelSlot(rebrewingStandContainer, 0, 12, 12));
        this.addSlot(new OriginalPotionSlot(rebrewingStandContainer, 1, 79, 12));
        this.addSlot(new IngredientSlot(rebrewingStandContainer, 2, 102, 19));
        this.addSlot(new PotionSlot(rebrewingStandContainer, 3, 56, 51));
        this.addSlot(new PotionSlot(rebrewingStandContainer, 4, 79, 58));
        this.addSlot(new PotionSlot(rebrewingStandContainer, 5, 102, 51));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.addDataSlots(rebrewingStandContainerData);
    }

    public ItemStack quickMoveStack(Player player, int pIndex) {
        ItemStack movedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            movedStack = itemstack1.copy();
            if (pIndex < 0 || pIndex > 5) {
                if (FuelSlot.mayPlaceItem(movedStack) ? this.moveItemStackTo(itemstack1, 0, 1, false) : (OriginalPotionSlot.mayPlaceItem(itemstack1) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (IngredientSlot.mayPlaceItem(movedStack) ? !this.moveItemStackTo(itemstack1, 2, 3, false) : (PotionSlot.mayPlaceItem(movedStack) ? !this.moveItemStackTo(itemstack1, 3, 6, false) : (pIndex >= 6 && pIndex < 33 ? !this.moveItemStackTo(itemstack1, 33, 42, false) : (pIndex >= 33 && pIndex < 42 ? !this.moveItemStackTo(itemstack1, 6, 33, false) : !this.moveItemStackTo(itemstack1, 6, 42, false))))))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(itemstack1, 6, 42, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, movedStack);
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == movedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return movedStack;
    }

    public int getBrewingTicks() {
        return this.rebrewingStandData.get(0);
    }

    public int getFuel() {
        return this.rebrewingStandData.get(1);
    }

    public int getCost() {
        return this.rebrewingStandData.get(2);
    }

    public boolean stillValid(Player player) {
        return this.rebrewingStand.stillValid(player);
    }

    static class FuelSlot
    extends Slot {
        public FuelSlot(Container pContainer, int slot, int pX, int pY) {
            super(pContainer, slot, pX, pY);
        }

        public static boolean mayPlaceItem(ItemStack itemStack) {
            return itemStack.is((Item)ModItems.CROPRESSED_NETHERWART.get());
        }

        public boolean mayPlace(ItemStack stack) {
            return FuelSlot.mayPlaceItem(stack);
        }

        public int getMaxStackSize() {
            return 64;
        }
    }

    static class OriginalPotionSlot
    extends Slot {
        public OriginalPotionSlot(Container pContainer, int slot, int pX, int pY) {
            super(pContainer, slot, pX, pY);
        }

        public static boolean mayPlaceItem(ItemStack itemStack) {
            return itemStack.is((Item)ModItems.EXTRACTED_BOTTLE.get());
        }

        public boolean mayPlace(ItemStack stack) {
            return OriginalPotionSlot.mayPlaceItem(stack);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }

    static class IngredientSlot
    extends Slot {
        public IngredientSlot(Container pContainer, int slot, int pX, int pY) {
            super(pContainer, slot, pX, pY);
        }

        public static boolean mayPlaceItem(ItemStack itemStack) {
            return itemStack.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_AMPLIFIER.get())) || itemStack.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LENGTH.get())) || itemStack.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_SPLASH.get())) || itemStack.is(ModServerConfig.itemFromLoc((String)ModServerConfig.REBREWING_LINGERING.get()));
        }

        public boolean mayPlace(ItemStack stack) {
            return IngredientSlot.mayPlaceItem(stack);
        }

        public int getMaxStackSize() {
            return 64;
        }
    }

    static class PotionSlot
    extends Slot {
        public PotionSlot(Container pContainer, int slot, int pX, int pY) {
            super(pContainer, slot, pX, pY);
        }

        public static boolean mayPlaceItem(ItemStack itemStack) {
            return ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER);
        }

        public boolean mayPlace(ItemStack stack) {
            return PotionSlot.mayPlaceItem(stack);
        }

        public void onTake(Player player, ItemStack stack) {
            if (player instanceof ServerPlayer && stack.is(ModTags.ModItemTags.REBREWED_POTIONS)) {
                Optional potion = ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).potion();
                potion.ifPresent(potionHolder -> CriteriaTriggers.BREWED_POTION.trigger((ServerPlayer)player, potionHolder));
            }
            super.onTake(player, stack);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

