/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.screen.cookbook;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.client.gui.screen.cookbook.EffectWidget;
import net.abraxator.moresnifferflowers.client.gui.screen.cookbook.ItemWidget;
import net.abraxator.moresnifferflowers.client.gui.screen.cookbook.TypeWidget;
import net.abraxator.moresnifferflowers.nutrition.Nutrition;
import net.abraxator.moresnifferflowers.nutrition.NutritionEntry;
import net.abraxator.moresnifferflowers.nutrition.NutritionLoader;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CookbookScreen
extends Screen {
    private static final ResourceLocation TEXTURE = MoreSnifferFlowers.loc("textures/gui/cookbook.png");
    public static final ResourceLocation RENDERABLES = MoreSnifferFlowers.loc("textures/gui/cookbook_renderables.png");
    public static final ResourceLocation GUIDE_0 = MoreSnifferFlowers.loc("textures/gui/cookbook_guide1.png");
    public static final ResourceLocation GUIDE_1 = MoreSnifferFlowers.loc("textures/gui/cookbook_guide2.png");
    private final int ROWS = 8;
    private final int COLUMNS = 5;
    private final int PAGE_SIZE = 40;
    private final int SCROLLBAR_HEIGHT = 142;
    private final int SCROLLER_HEIGHT = 15;
    private final List<String> mods;
    private final Set<Item> unlocked;
    public Page page = Page.CONTENTS;
    public int guide_page = 0;
    public NutritionType type;
    private List<Nutrition> nutritions = new ArrayList<Nutrition>();
    private float scrollOffs;
    private int startIndex;
    private boolean isScrolling;
    public int yOffset = 0;
    public int yTotal = 0;
    public static int MAX_Y = 140;

    public CookbookScreen(Set<Item> unlocked) {
        super((Component)Component.empty());
        this.mods = new ArrayList<String>(NutritionLoader.modNutritions.keySet());
        this.unlocked = unlocked;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - 272) / 2;
        int y = (this.height - 180) / 2;
        if (this.page == Page.ITEMS) {
            this.renderItems(guiGraphics, mouseX, mouseY, x, y);
        }
        if (this.page == Page.GUIDE) {
            this.renderGuide(guiGraphics, mouseX, mouseY, x, y);
        }
        this.renderContents(guiGraphics, mouseX, mouseY, x, y);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - 272) / 2;
        int y = (this.height - 180) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, 272, 180, 512, 256);
    }

    public void renderNutritionInfo(GuiGraphics guiGraphics, Nutrition nutrition) {
        int x = (this.width - 272) / 2;
        int y = (this.height - 180) / 2;
        int xPos = x + 150;
        int yPos = y + 20;
        ItemStack item = nutrition.getItem().getDefaultInstance();
        String string = item.getDisplayName().getString();
        int nameLength = string.length();
        guiGraphics.drawWordWrap(this.font, FormattedText.of((String)string, (Style)Style.EMPTY.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true))), xPos, yPos, 108, ChatFormatting.DARK_GRAY.getColor().intValue());
        if (nameLength > 16) {
            yPos += 9;
        }
        for (NutritionEntry nutritionEntry : nutrition.getNutritionEntries()) {
            MutableComponent nutritionName = Component.translatable((String)("gui.moresnifferflowers.cookbook." + nutritionEntry.nutrition().name)).withStyle(ChatFormatting.BOLD);
            guiGraphics.drawString(this.font, (Component)nutritionName.append(" : ").append(String.valueOf(nutritionEntry.weight())), xPos, yPos += 10, nutritionEntry.nutrition().color);
        }
    }

    public void renderEffectInfo(GuiGraphics guiGraphics, MobEffect effect, boolean isPositive) {
        int x = (this.width - 272) / 2;
        int y = (this.height - 180) / 2;
        int xPos = x + 150;
        int yPos = y + 20;
        String string = effect.getDisplayName().getString();
        int nameLength = string.length();
        int color = isPositive ? 6787356 : 9251362;
        guiGraphics.drawWordWrap(this.font, FormattedText.of((String)string, (Style)Style.EMPTY.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true))), xPos, yPos, 100, color);
        MutableComponent effectDescription = Component.translatable((String)(effect.getDescriptionId() + ".description")).withStyle(ChatFormatting.DARK_GRAY);
        guiGraphics.drawWordWrap(this.font, (FormattedText)effectDescription, xPos, yPos += 15, 108, ChatFormatting.DARK_GRAY.getColor().intValue());
    }

    private void renderGuide(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        ResourceLocation texture = this.guide_page == 0 ? GUIDE_0 : GUIDE_1;
        guiGraphics.blit(texture, x + 10, y, 0, 0, 256, 176);
    }

    private void renderItems(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        int yPos;
        int xPos = 18;
        int yStarting = yPos = 16;
        guiGraphics.blit(RENDERABLES, x + 17, y + 15, 25, 0, 111, 144);
        for (int i = this.startIndex * 5 + 1; i < this.startIndex * 5 + 1 + 40 && i < this.nutritions.size() + 1; ++i) {
            Nutrition nutrition = this.nutritions.get(i - 1);
            boolean unlocked = this.unlocked.contains(nutrition.getItem());
            Nutrition nutrition2 = nutrition = unlocked ? nutrition : Nutrition.EMPTY;
            if (yPos >= 16) {
                this.addRenderableWidget((GuiEventListener)new ItemWidget(x + xPos, y + yPos, (Component)Component.empty(), nutrition, this));
            }
            if (i % 5 != 0) {
                xPos += 18;
                continue;
            }
            yPos += 18;
            xPos = 18;
        }
        if (xPos > 18) {
            yPos += 18;
        }
        xPos = 18;
        if (this.canRender(yPos += 4)) {
            this.addRenderableWidget((GuiEventListener)new EffectWidget(x + xPos, y + yPos, (Component)Component.empty(), this.type, this, false));
        }
        if (this.canRender(yPos += 25)) {
            this.addRenderableWidget((GuiEventListener)new EffectWidget(x + xPos, y + yPos, (Component)Component.empty(), this.type, this, true));
        }
        boolean scrollable = this.yTotal > MAX_Y;
        int scrollAmount = (int)(127.0f * this.scrollOffs);
        guiGraphics.blit(RENDERABLES, x + 115, y + 16 + scrollAmount, scrollable ? 0 : 12, 0, 12, 15);
        this.yTotal = yPos - yStarting + this.startIndex * 18 + 10;
    }

    public boolean canRender(int yPos) {
        return yPos >= 16 && yPos <= MAX_Y + 10;
    }

    private void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        int i;
        for (i = 0; i < NutritionType.values().length; ++i) {
            NutritionType type = NutritionType.byId(i);
            this.addRenderableWidget((GuiEventListener)new TypeWidget(x + 271, y + 24 * i + 13 + i * 2, type, 24, 24, (Component)Component.literal((String)type.name), this));
        }
        i = 5;
        this.addRenderableWidget((GuiEventListener)new TypeWidget(x + 271, y + 24 * i + 13 + i * 2, null, 24, 24, (Component)Component.literal((String)"Guide"), this));
    }

    public void pageToItems(NutritionType type) {
        ArrayList<Nutrition> list = new ArrayList<Nutrition>(NutritionLoader.typeNutritions.get((Object)type).stream().toList());
        list.sort(Comparator.comparing(nutrition -> {
            float weight = 0.0f;
            for (NutritionEntry entry : nutrition.getNutritionEntries()) {
                if (entry.nutrition().equals((Object)type)) {
                    weight += (float)entry.weight();
                    continue;
                }
                weight += 0.001f * (float)entry.weight();
            }
            return Float.valueOf(-weight);
        }));
        this.nutritions = list;
        this.turnPage(Page.ITEMS);
    }

    public void turnPage(Page page) {
        this.startIndex = 0;
        this.yTotal = 0;
        this.guide_page = 0;
        this.page = page;
        this.clearWidgets();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = (this.width - 272) / 2;
        int y = (this.height - 180) / 2;
        if (this.page == Page.GUIDE) {
            if (this.guide_page == 0) {
                this.guide_page = 1;
            } else if (this.guide_page == 1) {
                this.guide_page = 0;
            }
        }
        this.isScrolling = CookbookScreen.isMouseOver(mouseX, mouseY, x + 115, y + 15, 15, MAX_Y) && this.page == Page.ITEMS;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.page == Page.ITEMS && this.isScrolling) {
            this.mouseScrolled(mouseX, mouseY, 0.0, -dragY / 40.0);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int totalItems = this.nutritions.size();
        int maxRows = Math.max(1, (int)Math.ceil((double)totalItems / 5.0));
        float value = (float)(this.yTotal - MAX_Y) / 18.0f;
        int scrollableRows = Math.max(0, Mth.ceil((float)value));
        if (scrollableRows > 0) {
            float f = (float)scrollY / (float)scrollableRows;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)Math.max(this.scrollOffs * (float)scrollableRows, 0.0f);
            if (this.startIndex > scrollableRows) {
                this.startIndex = scrollableRows;
            }
            this.clearWidgets();
        }
        return true;
    }

    private int getTotalRowCount() {
        return Mth.positiveCeilDiv((int)this.nutritions.size(), (int)5);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }

    public static enum Page {
        CONTENTS,
        ITEMS,
        GUIDE;

    }
}

