/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.abraxator.moresnifferflowers.client.model.entity.BoblingAnimations;
import net.abraxator.moresnifferflowers.entities.BoblingEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BoblingModel<T extends BoblingEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart torso_lower;
    private final ModelPart torso_upper;
    private final ModelPart legs;
    private final ModelPart right_feet;
    private final ModelPart left_feet;
    private final ModelPart head;
    private final ModelPart leaves;

    public BoblingModel(ModelPart root) {
        this.root = root.getChild("root");
        this.torso_lower = this.root.getChild("torso_lower");
        this.torso_upper = this.root.getChild("torso_upper");
        this.legs = this.root.getChild("legs");
        this.right_feet = this.legs.getChild("right_feet");
        this.left_feet = this.legs.getChild("left_feet");
        this.head = this.root.getChild("head");
        this.leaves = this.head.getChild("leaves");
    }

    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)24.0f, (float)0.5f));
        PartDefinition torso_lower = root.addOrReplaceChild("torso_lower", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition torso_upper = root.addOrReplaceChild("torso_upper", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition torso_upper_r1 = torso_upper.addOrReplaceChild("torso_upper_r1", CubeListBuilder.create().texOffs(17, 24).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9599f, (float)0.0f));
        PartDefinition legs = root.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition right_feet = legs.addOrReplaceChild("right_feet", CubeListBuilder.create().texOffs(0, 16).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(12, 16).addBox(-0.5f, 1.0f, -1.5f, 1.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_feet = legs.addOrReplaceChild("left_feet", CubeListBuilder.create().texOffs(0, 16).addBox(-0.5f, 1.0f, -1.5f, 1.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 17).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(20, 16).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition leaves = head.addOrReplaceChild("leaves", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition leaf2_r1 = leaves.addOrReplaceChild("leaf2_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -4.5f, 0.0f, 16.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0303f, (float)-3.5f, (float)0.0303f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leaf1_r1 = leaves.addOrReplaceChild("leaf1_r1", CubeListBuilder.create().texOffs(0, 8).addBox(-8.0f, -8.0f, 0.0429f, 16.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.right_feet.xRot = Mth.cos((float)(limbSwing * 0.8f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.left_feet.xRot = Mth.cos((float)(limbSwing * 0.8f)) * 1.4f * limbSwingAmount;
        this.torso_upper.zRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.1f * limbSwingAmount;
        this.head.zRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
        this.animate(((BoblingEntity)((Object)entity)).plantingAnimationState, BoblingAnimations.PLANT, ageInTicks);
        this.animate(((BoblingEntity)((Object)entity)).idleAnimationState, BoblingAnimations.IDLE, ageInTicks);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }
}

