/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.BerootCauldronBlockEntity;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.nikdo53.tinymultiblocklib.client.IMultiblockRenderHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class BerootCauldronRenderer<T extends BerootCauldronBlockEntity>
implements BlockEntityRenderer<T>,
IMultiblockRenderHelper {
    private final ModelPart cauldron;
    private final ModelPart spoon;

    public BerootCauldronRenderer(BlockEntityRendererProvider.Context context) {
        this.cauldron = context.bakeLayer(ModModelLayerLocations.BEROOT_CAULDRON);
        this.spoon = context.bakeLayer(ModModelLayerLocations.BEROOT_SPOON);
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Material CAULDRON_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/beroot_cauldron"));
        Material SPOON_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/beroot_spoon"));
        PreviewMode previewMode = ((BerootCauldronBlockEntity)blockEntity).previewMode;
        Function renderType = this.getRenderTypeFunction(previewMode);
        VertexConsumer cauldron_consumer = CAULDRON_TEXTURE.buffer(buffer, renderType);
        VertexConsumer spoon_consumer = SPOON_TEXTURE.buffer(buffer, renderType);
        RandomSource randomSource = this.level().getRandom();
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        if (blockEntity.isCenter()) {
            poseStack.pushPose();
            poseStack.translate(1.0, 1.5, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(-180.0f));
            this.rotate(poseStack, direction, false);
            this.render(this.cauldron, poseStack, cauldron_consumer, packedLight, packedOverlay, previewMode);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(1.0, 0.5, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(-180.0f));
            this.rotate(poseStack, direction, false);
            PoseStack.Pose pose = poseStack.last();
            Matrix4f matrix4f = pose.pose();
            Matrix3f matrix3f = pose.normal();
            int soupCount = ((BerootCauldronBlockEntity)blockEntity).soupCount;
            float size = 1.5f;
            float halfSize = size / 2.0f;
            float minX = -halfSize;
            float maxX = halfSize;
            float minZ = -halfSize;
            float maxZ = halfSize;
            float r = (float)(((BerootCauldronBlockEntity)blockEntity).color().x / 255.0);
            float g = (float)(((BerootCauldronBlockEntity)blockEntity).color().y / 255.0);
            float b = (float)(((BerootCauldronBlockEntity)blockEntity).color().z / 255.0);
            float y = -(0.16666667f * (float)soupCount);
            float soupScale = 0.332f;
            if (soupCount > 0) {
                poseStack.scale(1.0f + soupScale, 1.0f, 1.0f + soupScale);
                poseStack.translate((double)(-soupScale) * 0.565, 0.0, (double)soupScale * 0.565);
                this.renderFace(matrix4f, pose, buffer.getBuffer(RenderType.cutoutMipped()), r, g, b, 1.0f, minX, maxX, y, minZ, maxZ, packedLight, ((BerootCauldronBlockEntity)blockEntity).isCrafted);
            }
            poseStack.popPose();
            float rot = -((BerootCauldronBlockEntity)blockEntity).getSpoonRotation(partialTick);
            poseStack.pushPose();
            poseStack.translate(1.0, 1.5, 0.0);
            poseStack.mulPose(Axis.XN.rotationDegrees(-180.0f));
            this.rotate(poseStack, direction, false);
            poseStack.mulPose(new Quaternionf().rotationY((float)((double)rot * (Math.PI / 180))));
            this.render(this.spoon, poseStack, spoon_consumer, packedLight, packedOverlay, previewMode);
            poseStack.popPose();
            for (int i = 0; i < ((BerootCauldronBlockEntity)blockEntity).ingredients.getValidSize(); ++i) {
                poseStack.pushPose();
                this.rotate(poseStack, direction, true);
                ItemStack itemStack = (ItemStack)((BerootCauldronBlockEntity)blockEntity).ingredients.get(i);
                float speed = (float)randomSource.nextIntBetweenInclusive(50, 100) / 100.0f;
                float rot2 = (float)((double)((BerootCauldronBlockEntity)blockEntity).getItemsRotation(partialTick) * ((double)(i + 1) * 0.1));
                float a = (float)((double)i * 0.05);
                poseStack.translate(0.8 + (double)a, (double)(-y + 0.51f), 0.0 - (double)a);
                poseStack.mulPose(new Quaternionf().rotationY((float)((double)rot2 * (Math.PI / 180))));
                poseStack.translate(0.25, 0.0, 0.25);
                poseStack.mulPose(new Quaternionf().rotationY((float)((double)rot2 * 0.2 * (Math.PI / 180))));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, blockEntity.getLevel(), (int)(blockEntity.getBlockPos().asLong() + (long)i));
                poseStack.popPose();
            }
        }
    }

    private void rotate(PoseStack poseStack, Direction direction, Boolean isItems) {
        if (!isItems.booleanValue()) {
            switch (direction) {
                case EAST: {
                    poseStack.translate(0.0f, 0.0f, -1.0f);
                    break;
                }
                case WEST: {
                    poseStack.translate(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.translate(-1.0f, 0.0f, -1.0f);
                }
            }
        } else {
            switch (direction) {
                case EAST: {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                    break;
                }
                case WEST: {
                    poseStack.translate(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.translate(-1.0f, 0.0f, 1.0f);
                }
            }
            poseStack.translate(0.0, 0.0, 0.1);
        }
        if (!isItems.booleanValue()) {
            poseStack.mulPose(direction.getRotation());
        }
        if (!isItems.booleanValue()) {
            poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
        }
    }

    private void renderFace(Matrix4f pose, PoseStack.Pose normal, VertexConsumer consumer, float red, float green, float blue, float alpha, float x0, float x1, float y, float z0, float z1, int light, boolean isCrafted) {
        String name = isCrafted ? "beroot_soup1" : "beroot_soup";
        ResourceLocation resourceLocation = MoreSnifferFlowers.loc("block/" + name);
        TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(resourceLocation);
        consumer.addVertex(pose, x1, y, z0).setColor(red, green, blue, alpha).setUv(sprite.getU0(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(normal, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, x1, y, z1).setColor(red, green, blue, alpha).setUv(sprite.getU0(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(normal, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, x0, y, z1).setColor(red, green, blue, alpha).setUv(sprite.getU1(), sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(normal, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, x0, y, z0).setColor(red, green, blue, alpha).setUv(sprite.getU1(), sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(normal, 0.0f, 1.0f, 0.0f);
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return new AABB(((BerootCauldronBlockEntity)blockEntity).center).inflate(1.0);
    }
}

