/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.BondripiaBlockEntity;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.client.IMultiblockRenderHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.jetbrains.annotations.NotNull;

public class BondripiaBlockEntityRenderer<T extends BondripiaBlockEntity>
implements BlockEntityRenderer<T>,
IMultiblockRenderHelper {
    private ModelPart model;
    private static final Material BONDRIPIA_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/bondripia"));
    private static final Material ACIDRIPIA_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/acidripia"));

    public BondripiaBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = context.bakeLayer(ModModelLayerLocations.BONDRIPIA);
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (blockEntity.isCenter() && (Integer)blockEntity.getBlockState().getValue((Property)ModStateProperties.AGE_2) >= 2) {
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            PreviewMode previewMode = blockEntity.getPreviewMode();
            VertexConsumer consumer = this.getConsumer(buffer, (IMultiBlockEntity)blockEntity, BONDRIPIA_TEXTURE, ACIDRIPIA_TEXTURE, (Block)ModBlocks.ACIDRIPIA.get());
            this.render(this.model, poseStack, consumer, packedLight, packedOverlay, previewMode);
        }
    }

    public int getViewDistance() {
        return 256;
    }

    @NotNull
    public AABB getRenderBoundingBox(T blockEntity) {
        return new AABB(((BondripiaBlockEntity)((Object)blockEntity)).center).inflate(1.0);
    }
}

