/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.SaltemoneBlockEntity;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.client.IMultiblockRenderHelper;
import net.nikdo53.tinymultiblocklib.components.PreviewMode;
import org.jetbrains.annotations.NotNull;

public class SaltemoneBlockEntityRenderer<T extends SaltemoneBlockEntity>
implements BlockEntityRenderer<T>,
IMultiblockRenderHelper {
    private final ModelPart body;
    private final ModelPart top;
    private static final Material SALTEMONE_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/saltemone"));
    private static final Material SOURLEMON_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MoreSnifferFlowers.loc("block/sourlemon"));

    public SaltemoneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.body = context.bakeLayer(ModModelLayerLocations.SALTEMONE);
        this.top = context.bakeLayer(ModModelLayerLocations.SALTEMONE_TOP);
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.getBlockState();
        if (IMultiBlock.isCenter((BlockState)blockState) && (Integer)blockState.getValue((Property)ModStateProperties.AGE_2) >= 2) {
            PreviewMode previewMode = ((SaltemoneBlockEntity)((Object)blockEntity)).previewMode;
            VertexConsumer consumer = this.getConsumer(buffer, (IMultiBlockEntity)blockEntity, SALTEMONE_TEXTURE, SOURLEMON_TEXTURE, (Block)ModBlocks.SOURLEMONE.get());
            poseStack.pushPose();
            Direction direction = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            poseStack.mulPose(direction.getCounterClockWise().getRotation());
            poseStack.mulPose(Axis.XN.rotationDegrees(-90.0f));
            poseStack.translate(0.0, -1.4, 0.0);
            switch (direction) {
                case EAST: {
                    poseStack.translate(-1.0f, 0.0f, 1.0f);
                    break;
                }
                case WEST: {
                    poseStack.translate(0.0f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.translate(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case NORTH: {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            this.render(this.body, poseStack, consumer, packedLight, packedOverlay, previewMode);
            float time = ((float)this.level().getGameTime() + partialTick) / 20.0f;
            float scale = 1.0f + 0.3f * Mth.sin((float)(time / 2.0f * ((float)Math.PI * 2) + (float)((SaltemoneBlockEntity)((Object)blockEntity)).center.getX() + (float)((SaltemoneBlockEntity)((Object)blockEntity)).center.getZ()));
            poseStack.scale(scale, scale / 1.5f + 0.4f, scale);
            poseStack.translate(0.0, (double)(-scale) + 2.32, 0.0);
            this.render(this.top, poseStack, consumer, packedLight, packedOverlay, previewMode);
            poseStack.popPose();
        }
    }

    public int getViewDistance() {
        return 256;
    }

    @NotNull
    public AABB getRenderBoundingBox(T blockEntity) {
        return new AABB(((SaltemoneBlockEntity)((Object)blockEntity)).center).inflate(1.0);
    }
}

