/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterNonNullList<E>
extends NonNullList<E> {
    private final List<E> list;
    @Nullable
    private final E defaultValue;

    protected BetterNonNullList(List<E> list, @Nullable E defaultValue) {
        super(list, defaultValue);
        this.list = list;
        this.defaultValue = defaultValue;
    }

    public static <E> BetterNonNullList<E> create() {
        return new BetterNonNullList<Object>(Lists.newArrayList(), null);
    }

    public static <E> BetterNonNullList<E> createWithCapacity(int initialCapacity) {
        return new BetterNonNullList<Object>(Lists.newArrayListWithCapacity((int)initialCapacity), null);
    }

    public static <E> BetterNonNullList<E> withSize(int size, E defaultValue) {
        Validate.notNull(defaultValue);
        Object[] aobject = new Object[size];
        Arrays.fill(aobject, defaultValue);
        return new BetterNonNullList<Object>(Arrays.asList(aobject), defaultValue);
    }

    @SafeVarargs
    public static <E> BetterNonNullList<E> of(E defaultValue, E ... elements) {
        return new BetterNonNullList<E>(Arrays.asList(elements), defaultValue);
    }

    public int getValidSize() {
        int size = 0;
        for (E entry : this.list) {
            if (this.isDefault(entry)) continue;
            ++size;
        }
        return size;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.list.size(); ++i) {
            E entry = this.list.get(i);
            if (!this.isDefault(entry)) continue;
            return i;
        }
        throw new RuntimeException("No empty Slot found");
    }

    public E getLastValid() {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            E entry = this.list.get(i);
            if (this.isDefault(entry)) continue;
            return entry;
        }
        throw new RuntimeException("List is Default");
    }

    public boolean isDefault(E o) {
        return o.toString().equals(this.defaultValue.toString()) || o.equals(this.defaultValue);
    }

    public boolean isFullyDefault() {
        for (E entry : this.list) {
            if (this.isDefault(entry)) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        return this.getValidSize() >= this.list.size();
    }

    public Stream<E> validStream() {
        return this.list.stream().filter(e -> !this.isDefault(e));
    }

    @NotNull
    public E setDefault(int index) {
        Object ret = this.get(index);
        this.list.set(index, this.defaultValue);
        return (E)ret;
    }
}

