/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record Dye(DyeColor color, int amount) {
    public static final Codec<Dye> CODEC = RecordCodecBuilder.create(dyeInstance -> dyeInstance.group((App)Codec.INT.fieldOf("color").forGetter(Dye::colorId), (App)Codec.INT.fieldOf("amount").forGetter(Dye::amount)).apply((Applicative)dyeInstance, (colorId, amount) -> new Dye(Dye.colorFromId(colorId), (int)amount)));
    public static final Dye EMPTY = new Dye(DyeColor.WHITE, 0);

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public static Dye getDyeFromDyeStack(ItemStack dyeStack) {
        return new Dye(((DyeItem)dyeStack.getItem()).getDyeColor(), dyeStack.getCount());
    }

    public static Dye getDyeFromDyespria(ItemStack dyespria) {
        return (Dye)dyespria.getOrDefault(ModDataComponents.DYE, (Object)EMPTY);
    }

    public static ItemStack stackFromDye(Dye dye) {
        return dye.isEmpty() ? ItemStack.EMPTY : new ItemStack((ItemLike)DyeItem.byColor((DyeColor)dye.color), dye.amount);
    }

    public static boolean dyeCheck(Dye dye, ItemStack dyeToInsert) {
        DyeItem dyeToInsertItem = (DyeItem)dyeToInsert.getItem();
        return dye.color.equals((Object)dyeToInsertItem.getDyeColor());
    }

    public static int colorForDye(Colorable colorable, DyeColor dyeColor) {
        return colorable.colorValues().getOrDefault(dyeColor, -1);
    }

    public static void setDyeToDyeHolderStack(ItemStack dyespria, ItemStack dyeToInsert, int amount) {
        Dye.setDyeToDyeHolderStack(dyespria, dyeToInsert, amount, DyespriaItem.getDyespriaUses(dyespria));
    }

    public static void setDyeToDyeHolderStack(ItemStack dyespria, ItemStack dyeToInsert, int amount, int uses) {
        DyeColor dyeColor = dyeToInsert.getItem() instanceof DyeItem ? ((DyeItem)dyeToInsert.getItem()).getDyeColor() : DyeColor.WHITE;
        dyespria.set(ModDataComponents.DYE, (Object)new Dye(dyeColor, amount));
        dyespria.set(ModDataComponents.COLOR, (Object)uses);
    }

    public static void setDyeColorToStack(ItemStack stack, DyeColor color, int amount) {
        stack.set(ModDataComponents.DYE, (Object)new Dye(color, amount));
    }

    public static DyeColor colorFromId(int id) {
        return DyeColor.byId((int)id);
    }

    public int colorId() {
        return this.color.getId();
    }
}

