/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.data;

import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateGenerator
extends BlockStateProvider {
    public ModBlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "moresnifferflowers", exFileHelper);
    }

    protected void registerStatesAndModels() {
        boolean[] bottleConditions;
        VariantBlockStateBuilder rebrewingStandVariantBuilder = this.getVariantBuilder((Block)ModBlocks.REBREWING_STAND_BOTTOM.get());
        for (boolean hasBottle0 : bottleConditions = new boolean[]{false, true}) {
            for (boolean hasBottle1 : bottleConditions) {
                for (boolean hasBottle2 : bottleConditions) {
                    String modelCode = (hasBottle0 ? "1" : "0") + (hasBottle1 ? "1" : "0") + (hasBottle2 ? "1" : "0");
                    ModelFile modelFile = this.rebrewingStandModel(modelCode);
                    rebrewingStandVariantBuilder.partialState().with((Property)BlockStateProperties.HAS_BOTTLE_0, (Comparable)Boolean.valueOf(hasBottle0)).with((Property)BlockStateProperties.HAS_BOTTLE_1, (Comparable)Boolean.valueOf(hasBottle1)).with((Property)BlockStateProperties.HAS_BOTTLE_2, (Comparable)Boolean.valueOf(hasBottle2)).addModels(new ConfiguredModel[]{new ConfiguredModel(modelFile)});
                }
            }
        }
        this.simpleBlock((Block)ModBlocks.POTTED_DYESPRIA.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.POTTED_DYESPRIA.getId().getPath(), "block/flower_pot_cross")).renderType("cutout")).texture("plant", this.blockTexture((Block)ModBlocks.DYESPRIA_PLANT.get())));
        this.simpleBlock((Block)ModBlocks.POTTED_CORRUPTED_SAPLING.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.POTTED_CORRUPTED_SAPLING.getId().getPath(), "block/flower_pot_cross")).renderType("cutout")).texture("plant", this.blockTexture((Block)ModBlocks.CORRUPTED_SAPLING.get())));
        this.simpleBlock((Block)ModBlocks.POTTED_VIVICUS_SAPLING.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.POTTED_VIVICUS_SAPLING.getId().getPath(), "block/flower_pot_cross")).renderType("cutout")).texture("plant", this.blockTexture((Block)ModBlocks.VIVICUS_SAPLING.get())));
        this.signBlock((StandingSignBlock)ModBlocks.CORRUPTED_SIGN.get(), (WallSignBlock)ModBlocks.CORRUPTED_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.CORRUPTED_PLANKS.get()));
        this.signBlock((StandingSignBlock)ModBlocks.VIVICUS_SIGN.get(), (WallSignBlock)ModBlocks.VIVICUS_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.VIVICUS_PLANKS.get()));
        this.hangingSignBlock((Block)ModBlocks.CORRUPTED_HANGING_SIGN.get(), (Block)ModBlocks.CORRUPTED_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.CORRUPTED_PLANKS.get()));
        this.hangingSignBlock((Block)ModBlocks.VIVICUS_HANGING_SIGN.get(), (Block)ModBlocks.VIVICUS_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.VIVICUS_PLANKS.get()));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    protected void logWoodSapling(RotatedPillarBlock log, RotatedPillarBlock slog, RotatedPillarBlock wood, RotatedPillarBlock swood, Block sapling) {
        this.logBlock(log);
        this.logBlock(slog);
        ResourceLocation sideTex = this.blockTexture((Block)log);
        this.axisBlock(wood, sideTex, sideTex);
        ResourceLocation sSideTex = this.blockTexture((Block)slog);
        this.axisBlock(swood, sSideTex, sSideTex);
        ResourceLocation saplingTex = this.prefix("block/" + this.name(sapling));
        this.simpleBlock(sapling, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(sapling), saplingTex)).renderType("cutout"));
    }

    protected void plankBlocks(String variant, Block plank, Block slab, StairBlock stair, Block button, Block fence, Block gate, Block plate, DoorBlock door, TrapDoorBlock trapdoor) {
        this.plankBlocks(variant, plank, slab, stair, button, fence, gate, plate, door, trapdoor, false);
    }

    protected void plankBlocks(String variant, Block plank, Block slab, StairBlock stair, Block button, Block fence, Block gate, Block plate, DoorBlock door, TrapDoorBlock trapdoor, boolean cutoutDoors) {
        String plankTexName = "block/" + variant + "_planks";
        String plankDir = "block/" + variant + "/";
        ConfiguredModel[] plankModels = ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank), this.prefix(plankTexName))).nextModel().build();
        this.simpleBlock(plank, plankModels);
        String slabDir = variant + "/";
        ConfiguredModel[] bottomSlabModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab), this.prefix(plankTexName), this.prefix(plankTexName), this.prefix(plankTexName))).build();
        ConfiguredModel[] topSlabModels = ConfiguredModel.builder().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[0].model).nextModel().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[1].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[2].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[3].model).build();
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).setModels(bottomSlabModels);
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).setModels(topSlabModels);
        this.getVariantBuilder(slab).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).setModels(plankModels);
        this.woodStairs(stair, plankTexName, variant);
        this.woodButton(button, plankTexName, variant);
        this.woodFence(fence, plankTexName, variant);
        this.woodGate(gate, plankTexName, variant);
        this.woodPlate(plate, plankTexName, variant);
        String doorDir = variant + "/";
        String trapdoorDir = variant + "/";
        this.doorBlockWithRenderType(door, doorDir + variant, this.prefix(variant + "_lower"), this.prefix(variant + "_upper"), cutoutDoors ? "cutout" : "solid");
        this.trapdoorBlockWithRenderType(trapdoor, trapdoorDir + variant, this.prefix(variant + "_trapdoor"), true, cutoutDoors ? "cutout" : "solid");
    }

    private BlockModelBuilder door(String name, String model, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.prefix("block/util/" + model))).texture("bottom", bottom)).texture("top", top)).texture("side", side);
    }

    protected void woodGate(Block gate, String texName, String variant) {
        String gateDir = variant + "/";
        ModelBuilder gate0 = this.models().fenceGate(gateDir + this.name(gate), this.prefix(texName));
        ModelBuilder open0 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open", this.prefix(texName));
        ModelBuilder wall0 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall", this.prefix(texName));
        ModelBuilder wallOpen0 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open", this.prefix(texName));
        this.getVariantBuilder(gate).forAllStatesExcept(arg_0 -> ModBlockStateGenerator.lambda$woodGate$0((ModelFile)gate0, (ModelFile)wall0, (ModelFile)wallOpen0, (ModelFile)open0, arg_0), new Property[]{FenceGateBlock.POWERED});
    }

    protected void woodFence(Block fence, String texName, String variant) {
        String fenceDir = variant + "/";
        ModelBuilder post0 = this.models().fencePost(fenceDir + this.name(fence) + "_post", this.prefix(texName));
        ModelBuilder side0 = this.models().fenceSide(fenceDir + this.name(fence) + "_side", this.prefix(texName));
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(fence).part().weight(10).modelFile((ModelFile)post0).nextModel().addModel()).end();
        PipeBlock.PROPERTY_BY_DIRECTION.forEach((arg_0, arg_1) -> ModBlockStateGenerator.lambda$woodFence$1(builder, (ModelFile)side0, arg_0, arg_1));
    }

    protected void woodPlate(Block plate, String texName, String variant) {
        String plateDir = variant + "/";
        ConfiguredModel[] unpressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate), "pressure_plate_up")).texture("texture", this.prefix(texName))).nextModel().build();
        ConfiguredModel[] pressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down", "pressure_plate_down")).texture("texture", this.prefix(texName))).build();
        this.getVariantBuilder(plate).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(false)).setModels(unpressed);
        this.getVariantBuilder(plate).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(true)).setModels(pressed);
    }

    protected void woodButton(Block button, String texName, String variant) {
        String buttonDir = variant + "/";
        ModelBuilder unpressed0 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button), "button")).texture("texture", this.prefix(texName));
        ModelBuilder pressed0 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed", "button_pressed")).texture("texture", this.prefix(texName));
        this.getVariantBuilder(button).forAllStates(arg_0 -> ModBlockStateGenerator.lambda$woodButton$2((ModelFile)pressed0, (ModelFile)unpressed0, arg_0));
    }

    protected void woodStairs(StairBlock block, String texName, String variant) {
        String stairsDir = variant + "/";
        ModelBuilder main0 = this.models().stairs(stairsDir + this.name((Block)block), this.prefix(texName), this.prefix(texName), this.prefix(texName));
        ModelBuilder inner0 = this.models().stairsInner(stairsDir + this.name((Block)block) + "_inner", this.prefix(texName), this.prefix(texName), this.prefix(texName));
        ModelBuilder outer0 = this.models().stairsOuter(stairsDir + this.name((Block)block) + "_outer", this.prefix(texName), this.prefix(texName), this.prefix(texName));
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> ModBlockStateGenerator.lambda$woodStairs$3((ModelFile)main0, (ModelFile)inner0, (ModelFile)outer0, arg_0), new Property[]{StairBlock.WATERLOGGED});
    }

    private ModelFile rebrewingStandModel(String index) {
        return this.models().getExistingFile(MoreSnifferFlowers.loc("block/rebrewing_stand_" + index));
    }

    private ResourceLocation prefix(String path) {
        return MoreSnifferFlowers.loc("textures/" + path);
    }

    protected ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    protected String name(Block block) {
        return this.key(block).getPath();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodStairs$3(ModelFile main0, ModelFile inner0, ModelFile outer0, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        int yRot = (int)facing.getClockWise().toYRot();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        return ConfiguredModel.builder().weight(10).modelFile(shape == StairsShape.STRAIGHT ? main0 : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? inner0 : outer0)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodButton$2(ModelFile pressed0, ModelFile unpressed0, BlockState state) {
        ModelFile model0 = (Boolean)state.getValue((Property)ButtonBlock.POWERED) != false ? pressed0 : unpressed0;
        int rotX = switch ((AttachFace)state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.WALL -> 90;
            case AttachFace.FLOOR -> 0;
            case AttachFace.CEILING -> 180;
        };
        int rotY = 0;
        if (state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE) == AttachFace.CEILING) {
            switch ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) {
                case NORTH: {
                    rotY = 180;
                    break;
                }
                case WEST: {
                    rotY = 90;
                    break;
                }
                case EAST: {
                    rotY = 270;
                }
            }
        } else {
            switch ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) {
                case SOUTH: {
                    rotY = 180;
                    break;
                }
                case WEST: {
                    rotY = 270;
                    break;
                }
                case EAST: {
                    rotY = 90;
                }
            }
        }
        boolean uvlock = state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE) == AttachFace.WALL;
        return ConfiguredModel.builder().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model0).nextModel().build();
    }

    private static /* synthetic */ void lambda$woodFence$1(MultiPartBlockStateBuilder builder, ModelFile side0, Direction dir, BooleanProperty value) {
        if (dir.getAxis().isHorizontal()) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().weight(10).modelFile(side0).rotationY(((int)dir.toYRot() + 180) % 360).uvLock(true).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true});
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodGate$0(ModelFile gate0, ModelFile wall0, ModelFile wallOpen0, ModelFile open0, BlockState state) {
        ModelFile model0 = gate0;
        if (((Boolean)state.getValue((Property)FenceGateBlock.IN_WALL)).booleanValue()) {
            model0 = wall0;
        }
        if (((Boolean)state.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
            model0 = model0 == wall0 ? wallOpen0 : open0;
        }
        return ConfiguredModel.builder().weight(10).modelFile(model0).rotationY((int)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot()).uvLock(true).nextModel().build();
    }
}

