/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.data.datamaps;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.abraxator.moresnifferflowers.data.datamaps.ModDataMaps;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record Corruptable(List<Pair<Block, Integer>> list) {
    public static final Codec<Pair<Block, Integer>> PAIR_CODEC = Codec.pair((Codec)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").codec(), (Codec)Codec.INT.fieldOf("weight").codec());
    public static final Codec<Corruptable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PAIR_CODEC.listOf().fieldOf("value").forGetter(Corruptable::list)).apply((Applicative)instance, Corruptable::new));
    public static final Map<Block, Block> HARDCODED_BLOCK = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put((Block)ModBlocks.DYESPRIA_PLANT.get(), (Block)ModBlocks.DYESCRAPIA_PLANT.get());
        map.put((Block)ModBlocks.DAWNBERRY_VINE.get(), (Block)ModBlocks.GLOOMBERRY_VINE.get());
        map.put((Block)ModBlocks.BONMEELIA.get(), (Block)ModBlocks.BONWILTIA.get());
        map.put((Block)ModBlocks.BONDRIPIA.get(), (Block)ModBlocks.ACIDRIPIA.get());
        map.put((Block)ModBlocks.AMBUSH_BOTTOM.get(), (Block)ModBlocks.GARBUSH_BOTTOM.get());
        map.put((Block)ModBlocks.AMBUSH_TOP.get(), (Block)ModBlocks.GARBUSH_TOP.get());
        map.put((Block)ModBlocks.SALTEMONE.get(), (Block)ModBlocks.SOURLEMONE.get());
        map.put((Block)ModBlocks.CAULORFLOWER.get(), (Block)ModBlocks.PATTERNFLOWER.get());
        map.put((Block)ModBlocks.TORCHFLOWER_AFLAME.get(), (Block)ModBlocks.TORCHEWFLOWER.get());
        map.put(Blocks.TORCHFLOWER, (Block)ModBlocks.TORCHEWFLOWER.get());
    });

    public Corruptable(Block block) {
        this(List.of(Pair.of((Object)block, (Object)100)));
    }

    public static Optional<Block> getCorruptedBlock(Block block, Level level) {
        return Corruptable.getCorruptedBlock(block, level.random);
    }

    public static Optional<Block> getCorruptedBlock(Block block, RandomSource random) {
        Holder.Reference holder = block.builtInRegistryHolder();
        Corruptable corruptable = (Corruptable)holder.getData(ModDataMaps.CORRUPTABLE);
        Block hardcodedBlock = HARDCODED_BLOCK.getOrDefault(block, Blocks.AIR);
        if (hardcodedBlock != Blocks.AIR) {
            return Optional.of(hardcodedBlock);
        }
        if (corruptable != null) {
            List<Pair<Block, Integer>> corruptableList = corruptable.list();
            int totalWeight = corruptableList.stream().mapToInt(Pair::getSecond).sum();
            int randomValue = random.nextInt(totalWeight);
            int cumulativeWeight = 0;
            for (Pair<Block, Integer> pair : corruptableList) {
                if (randomValue >= (cumulativeWeight += ((Integer)pair.getSecond()).intValue())) continue;
                return Optional.of((Block)pair.getFirst());
            }
        }
        return Optional.empty();
    }

    public static boolean canBeCorrupted(Block block, Level level) {
        return Corruptable.canBeCorrupted(block, level.random);
    }

    public static boolean canBeCorrupted(Block block, RandomSource random) {
        if (block == null) {
            return false;
        }
        return Corruptable.getCorruptedBlock(block, random).isPresent();
    }
}

