/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.effects;

import java.util.ArrayList;
import java.util.Comparator;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SaltyEffect
extends MobEffect {
    public SaltyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            double reach = 3.0;
            LivingEntity entity = (LivingEntity)SaltyEffect.getClosestEntity(level, (LivingEntity)player, reach);
            if (entity == null) return true;
            player.attack((Entity)entity);
            entity.addEffect(new MobEffectInstance(ModEffects.SALTY, livingEntity.getEffect(ModEffects.SALTY).getDuration() / 2, amplifier));
            return true;
        }
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (livingEntity instanceof Enemy || livingEntity instanceof NeutralMob) {
                double reach = 1.5;
                LivingEntity entity = (LivingEntity)SaltyEffect.getClosestEntity(level, (LivingEntity)mob, reach);
                if (entity == null) return true;
                if (!mob.getSensing().hasLineOfSight((Entity)entity)) return true;
                mob.doHurtTarget((Entity)entity);
                entity.addEffect(new MobEffectInstance(ModEffects.SALTY, (int)((double)livingEntity.getEffect(ModEffects.SALTY).getDuration() / 1.5), amplifier));
                return true;
            }
        }
        livingEntity.removeEffect(ModEffects.SALTY);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % (1200 / (amplifier + 1)) == 0;
    }

    @Nullable
    public static Entity getClosestEntity(Level level, LivingEntity mid, double range) {
        Vec3 start = new Vec3(mid.getEyePosition().x - range, mid.getEyePosition().y - range, mid.getEyePosition().z - range);
        Vec3 end = new Vec3(mid.getEyePosition().x + range, mid.getEyePosition().y + range, mid.getEyePosition().z + range);
        ArrayList<Entity> list = new ArrayList<Entity>(level.getEntities((Entity)mid, new AABB(start, end)).stream().filter(entity -> entity instanceof LivingEntity && ((LivingEntity)entity).canBeSeenAsEnemy()).toList());
        if (list.isEmpty()) {
            return null;
        }
        list.sort(Comparator.comparing(entity -> {
            Vec3 pos1 = mid.position();
            Vec3 pos2 = entity.position();
            return pos1.distanceTo(pos2);
        }));
        return (Entity)list.get(0);
    }
}

