/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.effects;

import java.util.List;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class StickyEffect
extends MobEffect {
    public StickyEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        double pullRange = 8.0;
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, livingEntity.getBoundingBox().inflate(pullRange), item -> !item.hasPickUpDelay());
        for (ItemEntity item2 : nearbyItems) {
            StickyEffect.pullItemTowards(livingEntity, item2);
        }
        if (!level.isClientSide && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BlockPos pos = livingEntity.getOnPos();
            BlockState state = level.getBlockState(pos);
            Vec3 vec3 = pos.getCenter();
            boolean isRunning = player.isSprinting();
            int delay = 600 - amplifier * 50;
            if (delay < 1) {
                delay = 1;
            }
            if (isRunning && level.getGameTime() % (long)delay == 0L && state.is(ModTags.ModBlockTags.STICKABLE)) {
                level.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 0.5f + level.getRandom().nextFloat() * 0.8f);
                ItemEntity itemEntity = new ItemEntity(level, vec3.x, vec3.y + (double)0.6f, vec3.z, state.getBlock().asItem().getDefaultInstance());
                level.addFreshEntity((Entity)itemEntity);
                if (level.random.nextFloat() < 0.3f) {
                    livingEntity.addEffect(new MobEffectInstance(ModEffects.GLUED, 40 * amplifier, 0));
                }
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    private static void pullItemTowards(LivingEntity livingEntity, ItemEntity item) {
        Vec3 itemPos;
        Vec3 livingEntityPos = livingEntity.position().add(0.0, 1.0, 0.0);
        Vec3 direction = livingEntityPos.subtract(itemPos = item.position());
        if (direction.lengthSqr() < 0.5) {
            return;
        }
        direction = direction.normalize().scale(0.05);
        Vec3 currentVelocity = item.getDeltaMovement();
        Vec3 newVelocity = currentVelocity.add(direction).scale(0.95);
        item.setDeltaMovement(newVelocity);
    }
}

