/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.abraxator.moresnifferflowers.entities.goals.BoblingAttackPlayerGoal;
import net.abraxator.moresnifferflowers.entities.goals.BoblingAvoidPlayerGoal;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.SimpleAdvancementTrigger;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoblingEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> DATA_CURED = SynchedEntityData.defineId(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_RUNNING = SynchedEntityData.defineId(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_WANTED_POS = SynchedEntityData.defineId(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> DATA_PLANTING = SynchedEntityData.defineId(BoblingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int idleAnimationTimeout = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState plantingAnimationState = new AnimationState();
    private boolean finalizePlanting = false;
    private int plantingProgress = 0;
    private static final int MAX_PLANTING_PROGRESS = 35;

    public BoblingEntity(EntityType<? extends BoblingEntity> entityType, Level level, boolean type) {
        super(entityType, level);
        this.setCured(type);
    }

    public BoblingEntity(EntityType<? extends BoblingEntity> entityType, Level level) {
        this(entityType, level, false);
    }

    public BoblingEntity(Level level, boolean type) {
        this((EntityType<? extends BoblingEntity>)((EntityType)ModEntityTypes.BOBLING.get()), level, type);
    }

    public boolean isCured() {
        return (Boolean)this.entityData.get(DATA_CURED);
    }

    public void setCured(boolean type) {
        this.entityData.set(DATA_CURED, (Object)type);
    }

    public boolean isRunning() {
        return (Boolean)this.entityData.get(DATA_RUNNING);
    }

    public void setRunning(boolean running) {
        this.entityData.set(DATA_RUNNING, (Object)running);
    }

    @Nullable
    public BlockPos getWantedPos() {
        return ((Optional)this.entityData.get(DATA_WANTED_POS)).orElse(null);
    }

    public void setWantedPos(Optional<BlockPos> wantedPos) {
        this.entityData.set(DATA_WANTED_POS, wantedPos);
    }

    public boolean isPlanting() {
        return (Boolean)this.entityData.get(DATA_PLANTING);
    }

    public void setPlanting(boolean plan) {
        this.entityData.set(DATA_PLANTING, (Object)plan);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("cured", this.isCured());
        tag.putBoolean("running", this.isRunning());
        tag.putBoolean("planting", this.isPlanting());
        if (this.getWantedPos() != null) {
            tag.put("wanted_pos", NbtUtils.writeBlockPos((BlockPos)this.getWantedPos()));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCured(tag.getBoolean("cured"));
        this.setRunning(tag.getBoolean("running"));
        this.setPlanting(tag.getBoolean("planting"));
        this.setWantedPos(NbtUtils.readBlockPos((CompoundTag)tag, (String)"wanted_pos"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CURED, (Object)false);
        builder.define(DATA_RUNNING, (Object)false);
        builder.define(DATA_WANTED_POS, Optional.empty());
        builder.define(DATA_PLANTING, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BoblingAttackPlayerGoal(this, 1.5, false));
        this.goalSelector.addGoal(2, new BoblingAvoidPlayerGoal<Player>(this, Player.class, 16.0f, 1.0, 1.3f));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.8f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected void actuallyHurt(DamageSource damageSource, float pDamageAmount) {
        super.actuallyHurt(damageSource, pDamageAmount);
        if (this.isRunning() && damageSource.is(DamageTypes.PLAYER_ATTACK) && !this.isCured()) {
            double r = 1.0;
            double checkR = 1.5;
            HashSet<Vec3> set = new HashSet<Vec3>();
            Entity entity = damageSource.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ((SimpleAdvancementTrigger)((Object)ModAdvancementCritters.BOBLING_ATTACK.get())).trigger(serverPlayer);
            }
            if (((Boolean)ModServerConfig.CORRUPTED_BOBLING_GRIEFING.get()).booleanValue()) {
                for (double theta = 0.0; theta <= 6.2831854820251465; theta += (double)((float)Math.PI * 2 / (float)this.random.nextIntBetweenInclusive(2, 5))) {
                    this.generateProjectile(set, r, theta + this.level().random.nextDouble(), checkR);
                }
            }
        }
        if (!this.isRunning() && damageSource.is(DamageTypes.PLAYER_ATTACK)) {
            this.setRunning(true);
        }
    }

    protected int calculateFallDamage(float pFallDistance, float pDamageMultiplier) {
        if (this.tickCount <= 60) {
            return 0;
        }
        return super.calculateFallDamage(pFallDistance, pDamageMultiplier);
    }

    public void tick() {
        super.tick();
        if (this.isPlanting()) {
            ++this.plantingProgress;
            if (this.plantingProgress >= 35) {
                this.finalizePlanting = true;
                this.setPlanting(false);
            }
        }
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    public void aiStep() {
        for (WrappedGoal wrappedGoal : this.goalSelector.getAvailableGoals()) {
            if (wrappedGoal != null) continue;
            MoreSnifferFlowers.LOGGER.error("NULL");
        }
        for (WrappedGoal wrappedGoal : this.targetSelector.getAvailableGoals()) {
            if (wrappedGoal != null) continue;
            MoreSnifferFlowers.LOGGER.error("NULL");
        }
        super.aiStep();
        if (this.canPlant()) {
            this.plantingProgress = 0;
            this.setPlanting(true);
            this.removeFreeWill();
            this.setYRot(this.getDirection().toYRot());
        }
        if (this.finalizePlanting && this.isAlive()) {
            BlockPos blockPos = BlockPos.containing((Position)this.position()).relative(this.getDirection());
            if (!this.level().isClientSide) {
                boolean config = (Boolean)ModServerConfig.CORRUPTED_BOBLING_GRIEFING.get();
                boolean isReplaceable = this.level().getBlockState(blockPos).canBeReplaced();
                if (config || isReplaceable) {
                    this.level().setBlockAndUpdate(blockPos, ((Block)ModBlocks.CORRUPTED_SAPLING.get()).defaultBlockState());
                    if (this.level().getBlockState(blockPos.below()).canBeReplaced()) {
                        this.level().setBlockAndUpdate(blockPos.below(), ((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get()).defaultBlockState());
                    }
                }
            }
            this.discard();
        }
    }

    private boolean canPlant() {
        BlockPos pos = this.getWantedPos();
        return this.isRunning() && this.isAlive() && !this.isPlanting() && pos != null && this.level().getBlockState(pos).canBeReplaced() && this.level().getBlockState(pos.below()).isFaceSturdy((BlockGetter)this.level(), pos, Direction.UP) && this.position().closerThan((Position)pos.getCenter(), 0.75);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isPlanting()) {
            this.idleAnimationState.stop();
            if (!this.plantingAnimationState.isStarted()) {
                this.plantingAnimationState.start(this.tickCount);
            }
        } else {
            this.plantingAnimationState.stop();
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(ModItems.VIVICUS_ANTIDOTE) && !this.isCured()) {
            this.setCured(true);
            this.particles((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)7118872).toVector3f(), 1.0f));
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    private void particles(ParticleOptions particle) {
        for (int i = 0; i <= 30; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particle, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    private void generateProjectile(Set<Vec3> set, double r, double theta, double checkR) {
        double x = this.getX() + r * (double)Mth.cos((float)((float)theta)) * 0.8;
        double yx = this.getY() + r * (double)Mth.sin((float)((float)theta)) + 0.3;
        double yz = this.getY() + r * (double)Mth.cos((float)((float)theta)) + 0.3;
        double z = this.getZ() + r * (double)Mth.sin((float)((float)theta)) * 0.8;
        if (this.random.nextFloat() > 0.5f) {
            this.createAndAddProjectile(set, checkR, new Vec3(x, this.yo, z));
        }
        if (this.random.nextFloat() > 0.5f) {
            this.createAndAddProjectile(set, checkR, new Vec3(x, yx, this.zo));
        }
        if (this.random.nextFloat() > 0.5f) {
            this.createAndAddProjectile(set, checkR, new Vec3(this.xo, yz, z));
        }
    }

    private void createAndAddProjectile(Set<Vec3> set, double checkR, Vec3 vec3) {
        AABB aabb = AABB.ofSize((Vec3)vec3, (double)checkR, (double)checkR, (double)checkR);
        if (set.stream().noneMatch(arg_0 -> ((AABB)aabb).contains(arg_0))) {
            CorruptedProjectile projectile = new CorruptedProjectile(this.level());
            projectile.setPos(vec3);
            float slowdown = 2.8f;
            Vec3 dir = new Vec3((vec3.x() - this.getX()) / (double)slowdown, (vec3.y() - this.getY()) / (double)slowdown, (vec3.z() - this.getZ()) / (double)slowdown);
            projectile.setDeltaMovement(dir);
            this.level().addFreshEntity((Entity)projectile);
            set.add(vec3);
        }
    }
}

