/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DragonflyProjectile
extends ThrowableItemProjectile {
    public DragonflyProjectile(EntityType<? extends DragonflyProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public DragonflyProjectile(Level level, Player player) {
        super((EntityType)ModEntityTypes.DRAGONFLY.get(), (LivingEntity)player, level);
        this.setOwner((Entity)player);
    }

    public DragonflyProjectile(Level level) {
        super((EntityType)ModEntityTypes.DRAGONFLY.get(), level);
    }

    public void tick() {
        super.tick();
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.DRAGONFLY.get();
    }

    protected void onHit(HitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.ITEM, ((Item)ModItems.DRAGONFLY.get()).getDefaultInstance());
            serverLevel.sendParticles((ParticleOptions)particle, this.getX(), this.getY(), this.getZ(), 10, Mth.nextDouble((RandomSource)this.random, (double)0.0, (double)0.3), Mth.nextDouble((RandomSource)this.random, (double)0.0, (double)0.3), Mth.nextDouble((RandomSource)this.random, (double)0.0, (double)0.3), 0.0);
        }
        super.onHit(result);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 140, 2));
            entity2.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.3f);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }
}

