/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import java.util.Optional;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarOfAcidProjectile
extends ThrowableItemProjectile {
    private static final Logger log = LoggerFactory.getLogger(JarOfAcidProjectile.class);

    public JarOfAcidProjectile(LivingEntity pShooter, Level level) {
        super((EntityType)ModEntityTypes.JAR_OF_ACID.get(), pShooter, level);
    }

    public JarOfAcidProjectile(Level level) {
        super((EntityType)ModEntityTypes.JAR_OF_ACID.get(), level);
    }

    public JarOfAcidProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.JAR_OF_ACID.get();
    }

    private ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.ITEM, this.getItem());
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.degrowCrops(BlockPos.containing((Position)result.getLocation()));
        this.makeAreaOfEffectCloud(new PotionContents(Potions.STRONG_POISON));
        this.discard();
    }

    private void degrowCrops(BlockPos blockPos) {
        BlockPos.withinManhattanStream((BlockPos)blockPos, (int)2, (int)1, (int)2).forEach(pos -> {
            this.getProperty((BlockPos)pos).ifPresent(property -> {
                BlockState state = this.level().getBlockState(pos);
                state = (BlockState)state.setValue((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
                this.level().setBlock(pos, state, 2);
            });
            BlockState state = this.level().getBlockState(pos);
            if (state.is(BlockTags.LEAVES)) {
                this.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            }
            if (state.is(BlockTags.DIRT)) {
                this.level().setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
            }
        });
    }

    private Optional<Property<?>> getProperty(BlockPos pos) {
        return this.level().getBlockState(pos).getProperties().stream().filter(property -> property.getName().contains("age") && property instanceof IntegerProperty).findAny();
    }

    private void makeAreaOfEffectCloud(PotionContents pPotionContents) {
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            areaeffectcloud.setOwner(livingentity);
        }
        areaeffectcloud.setRadius(3.0f);
        areaeffectcloud.setRadiusOnUse(-0.5f);
        areaeffectcloud.setParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)11468636).toVector3f(), 1.0f));
        areaeffectcloud.setWaitTime(10);
        areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
        areaeffectcloud.setPotionContents(pPotionContents);
        this.level().addFreshEntity((Entity)areaeffectcloud);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 60, 2));
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

