/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import net.abraxator.moresnifferflowers.entities.SaltProjectile;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.toClient.SaltemoneParticlePacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SaltBubbleProjectile
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> CORRUPTED = SynchedEntityData.defineId(SaltBubbleProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(SaltBubbleProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private Vector3f pos;
    private int time;
    private float height;
    private float slowdown;
    private int maxTime;

    public SaltBubbleProjectile(EntityType<? extends SaltBubbleProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SaltBubbleProjectile(double x, double y, double z, Level level) {
        super((EntityType)ModEntityTypes.SALT_BUBBLE.get(), x, y, z, level);
        this.pos = new Vector3f((float)x, (float)y, (float)z);
        this.height = (float)level.random.nextIntBetweenInclusive(10, 20) + level.random.nextFloat();
        this.slowdown = 1.0f + 0.1f / (this.height * 2.0f);
        this.maxTime = level.random.nextIntBetweenInclusive(4800, 7200);
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean natural = true;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (source.getEntity() instanceof Player && !source.isDirect()) {
                int orbs = Mth.floor((float)(this.height / 2.0f));
                if (orbs < 3) {
                    orbs = 3;
                }
                int i = serverLevel.random.nextIntBetweenInclusive(2, orbs);
                ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)this.position(), (int)i);
                serverLevel.playSound(null, this.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 2.0f, 0.8f + this.random.nextFloat() * 0.4f);
                natural = false;
            }
        }
        this.pop(natural);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block4: {
            speed = this.getDeltaMovement();
            state = this.getState();
            if (this.pos == null || state != 0) break block4;
            if (this.pos.distance((Vector3fc)this.position().toVector3f()) > this.height) ** GOTO lbl-1000
            v0 = new Vec3(0.0, 0.0, 0.0);
            if (speed.distanceTo(v0) < 0.01) lbl-1000:
            // 2 sources

            {
                this.setState(1);
                this.setDeltaMovement(0.0, 0.0, 0.0);
            } else {
                this.setDeltaMovement(speed.x / (double)this.slowdown, speed.y / (double)this.slowdown, speed.z / (double)this.slowdown);
            }
        }
        if (this.pos != null) {
            ++this.time;
            if (this.time >= this.maxTime) {
                this.pop(true);
                return;
            }
        }
        super.tick();
    }

    public void pop(boolean natural) {
        int projectiles = natural ? ((Boolean)ModServerConfig.SALTEMONE_GRIEFING.get() != false && this.random.nextFloat() < 0.4f ? 1 : 0) : (this.random.nextFloat() < 0.25f ? 2 : 1);
        this.setState(2);
        for (int i = 0; i < projectiles; ++i) {
            SaltProjectile projectile = new SaltProjectile(this.level());
            projectile.moveTo(this.getX(), this.getY(), this.getZ());
            projectile.shoot((double)this.random.nextFloat() - 0.5, (double)this.random.nextFloat() + 0.5, (double)this.random.nextFloat() - 0.5, 0.5f, 1.0f);
            projectile.setCorrupted(this.isCorrupted());
            this.level().addFreshEntity((Entity)projectile);
            this.level().playSound(null, this.blockPosition(), SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, 10.0f + this.random.nextFloat() * 3.0f, 0.75f + this.random.nextFloat() / 2.0f);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SaltemoneParticlePacket(this.position().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.discard();
    }

    protected void updateRotation() {
        Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
        double d0 = vec3.horizontalDistance();
        this.setXRot(SaltBubbleProjectile.lerpRotation((float)this.xRotO, (float)((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875))));
        this.setYRot(SaltBubbleProjectile.lerpRotation((float)this.yRotO, (float)((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875))));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CORRUPTED, (Object)false);
        builder.define(STATE, (Object)0);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.SALTY_SPICE.get();
    }

    public boolean isCorrupted() {
        return (Boolean)this.entityData.get(CORRUPTED);
    }

    public void setCorrupted(boolean corrupted) {
        this.entityData.set(CORRUPTED, (Object)corrupted);
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("corrupted", this.isCorrupted());
        tag.putInt("state", this.getState());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCorrupted(tag.getBoolean("corrupted"));
        this.setState(tag.getInt("state"));
    }
}

