/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.List;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class DyescrapiaItem
extends BlockItem {
    public DyescrapiaItem(Item.Properties properties) {
        super((Block)ModBlocks.DYESCRAPIA_PLANT.get(), properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        Player player = context.getPlayer();
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        int uses = DyescrapiaItem.getDyescrapiaUses(stack) + 1;
        if (BlockPatternCapability.hasPattern(pos, level)) {
            if (!level.isClientSide) {
                if (uses >= 4) {
                    player.addItem(BlockPattern.fromId(BlockPatternCapability.getPattern(pos, level).patternId()).getItem().getDefaultInstance());
                    uses = 0;
                }
                BlockPatternCapability.removePattern(pos, level);
                stack.set(ModDataComponents.USES, (Object)uses);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        Block block = state.getBlock();
        if (block instanceof Colorable) {
            Colorable colorable = (Colorable)block;
            Dye dye = new Dye(colorable.getDyeFromBlock(state).color(), 1);
            if (!dye.color().equals((Object)DyeColor.WHITE)) {
                colorable.colorBlock(level, pos, state, new Dye(DyeColor.WHITE, 1));
                if (uses >= 4) {
                    player.addItem(Dye.stackFromDye(dye));
                    uses = 0;
                }
                stack.set(ModDataComponents.USES, (Object)uses);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else if (state.is(ModTags.ModBlockTags.DYED)) {
            String finalBlockId;
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String modId = location.getNamespace();
            String blockId = location.getPath();
            String validColorName = "white|light_gray|gray|black|brown|red|orange|yellow|lime|green|cyan|light_blue|blue|purple|magenta|pink";
            boolean colorless = false;
            if (blockId.endsWith("candle") || blockId.endsWith("shulker_box") || blockId.endsWith("terracotta") && !blockId.endsWith("glazed_terracotta")) {
                finalBlockId = blockId.replaceFirst(validColorName, "").replaceFirst("_", "");
                colorless = true;
            } else if (blockId.endsWith("stained_glass") || blockId.endsWith("stained_glass_pane")) {
                finalBlockId = blockId.replaceFirst(validColorName, "").replaceFirst("_stained_", "");
                colorless = true;
            } else {
                finalBlockId = blockId.replaceFirst(validColorName, "");
            }
            if (!(blockId.contains("white_") && !colorless || finalBlockId.equals(blockId))) {
                BlockEntity blockEntity;
                Block finalBlock = colorless ? (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)finalBlockId)) : (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)("white" + finalBlockId)));
                BlockState finalBlockState = finalBlock.defaultBlockState();
                BlockEntity originalShulker = level.getBlockEntity(pos);
                CompoundTag shulkerData = null;
                if (originalShulker instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity entity = (ShulkerBoxBlockEntity)originalShulker;
                    shulkerData = entity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                }
                if (finalBlock != Blocks.AIR) {
                    level.setBlockAndUpdate(pos, DyespriaItem.copyAllBlockStateProperties(state, finalBlockState));
                }
                if (shulkerData != null && (blockEntity = level.getBlockEntity(pos)) instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity newShulkerBox = (ShulkerBoxBlockEntity)blockEntity;
                    newShulkerBox.loadFromTag(shulkerData, (HolderLookup.Provider)level.registryAccess());
                }
                if (uses >= 4) {
                    String dyeName = blockId.replace(blockId.replaceFirst(validColorName, ""), "") + "_dye";
                    player.addItem(((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)dyeName))).getDefaultInstance());
                    uses = 0;
                }
                stack.set(ModDataComponents.USES, (Object)uses);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.FAIL;
        }
        return this.handlePlacement(pos, level, player, context.getHand(), context.getItemInHand());
    }

    private InteractionResult handlePlacement(BlockPos blockPos, Level level, Player player, InteractionHand hand, ItemStack stack) {
        BlockPos posForDyespria = blockPos.above();
        BlockHitResult blockHitResult = new BlockHitResult(posForDyespria.below().getCenter(), Direction.UP, posForDyespria.below(), false);
        UseOnContext useOnCtx = new UseOnContext(level, player, hand, stack, blockHitResult);
        InteractionResult result = super.useOn(useOnCtx);
        BlockEntity blockEntity = level.getBlockEntity(blockPos.above());
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            entity.dye = Dye.getDyeFromDyespria(stack);
            entity.setChanged();
        }
        return result;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        int input = DyescrapiaItem.getDyescrapiaUses(stack) - 1;
        int maxInput = 4;
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)DyescrapiaItem.getDyescrapiaUses(stack) * 13.0f / 4.0f);
    }

    public static int getDyescrapiaUses(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.USES, (Object)0);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatableWithFallback((String)"tooltip.dyescrapia", (String)"Scrapes the dye off of colored blocks").withStyle(ChatFormatting.GOLD));
    }
}

