/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.components.DyespriaMode;
import net.abraxator.moresnifferflowers.components.EntityDistanceComparator;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class DyespriaItem
extends BlockItem
implements Colorable {
    public DyespriaItem(Item.Properties properties) {
        super((Block)ModBlocks.DYESPRIA_PLANT.get(), properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        ItemStack stack = context.getItemInHand();
        Dye dye = Dye.getDyeFromDyespria(stack);
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (DyespriaItem.checkDyedBlock(blockState) || blockState.getBlock() instanceof Colorable && !dye.isEmpty() || BlockPatternCapability.hasPattern(blockPos, level) && !player.isCrouching()) {
            DyespriaMode dyespriaMode = (DyespriaMode)((Object)stack.getOrDefault(ModDataComponents.DYESPRIA_MODE, (Object)DyespriaMode.SINGLE));
            AtomicBoolean canContinueDyeing = new AtomicBoolean(true);
            DyespriaMode.DyespriaSelector dyespriaSelector = new DyespriaMode.DyespriaSelector(blockPos, blockState, this.getMatchTag(blockState), level, context.getClickedFace(), player.isCrouching());
            Set<BlockPos> set = dyespriaMode.getSelector().apply(dyespriaSelector);
            set.stream().sorted(new EntityDistanceComparator(blockPos)).takeWhile(t -> canContinueDyeing.get()).forEach(blockPos1 -> {
                BlockState state = level.getBlockState(blockPos1);
                if (!Dye.getDyeFromDyespria(stack).isEmpty()) {
                    this.colorOne(stack, level, (BlockPos)blockPos1, state, context.getClickedFace(), player, BlockPatternCapability.hasPattern(blockPos, level));
                } else {
                    canContinueDyeing.set(false);
                }
            });
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return this.handlePlacement(blockPos, level, player, context.getHand(), stack);
    }

    @Nullable
    private TagKey<Block> getMatchTag(BlockState blockState) {
        TagKey<Block> tagKey;
        if (blockState instanceof Colorable) {
            Colorable colorable = (Colorable)blockState;
            tagKey = colorable.matchTag();
        } else {
            tagKey = null;
        }
        return tagKey;
    }

    private InteractionResult handlePlacement(BlockPos blockPos, Level level, Player player, InteractionHand hand, ItemStack stack) {
        ItemStack oldStack = stack.copy();
        BlockPos posForDyespria = blockPos.above();
        BlockHitResult blockHitResult = new BlockHitResult(posForDyespria.below().getCenter(), Direction.UP, posForDyespria.below(), false);
        UseOnContext useOnCtx = new UseOnContext(level, player, hand, stack, blockHitResult);
        InteractionResult result = super.useOn(useOnCtx);
        BlockEntity blockEntity = level.getBlockEntity(blockPos.above());
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            entity.dye = Dye.getDyeFromDyespria(oldStack);
            if (DyespriaItem.getDyespriaUses(oldStack) < 4) {
                entity.dye = new Dye(entity.dye.color(), entity.dye.amount() - 1);
            }
            entity.setChanged();
        }
        return result;
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState state = super.getPlacementState(context);
        return state == null ? null : (BlockState)state.setValue((Property)ModStateProperties.AGE_3, (Comparable)Integer.valueOf(3));
    }

    public void colorOne(ItemStack stack, Level level, BlockPos blockPos, BlockState blockState, Direction face, Player player, boolean clickedPattern) {
        Dye dye = Dye.getDyeFromDyespria(stack);
        if (!this.canDye(blockState, dye)) {
            return;
        }
        if (BlockPatternCapability.hasPattern(blockPos, level) && !player.isCrouching() && clickedPattern) {
            this.colorPattern(dye, level, blockPos);
            this.finishColoring(dye, level, stack, blockPos, face);
            return;
        }
        Block block = blockState.getBlock();
        if (block instanceof Colorable) {
            Colorable colorable = (Colorable)block;
            if (colorable.canBeColored(blockState, dye)) {
                colorable.colorBlock(level, blockPos, blockState, dye);
                this.finishColoring(dye, level, stack, blockPos, face);
            }
        } else {
            this.dyeNonColorableBlock(blockState, blockPos, dye.color(), level);
            this.finishColoring(dye, level, stack, blockPos, face);
        }
    }

    public void colorPattern(Dye dye, Level level, BlockPos pos) {
        int patternId = BlockPatternCapability.getPattern(pos, level).patternId();
        int originalColor = BlockPatternCapability.getPattern(pos, level).color();
        int dyeColor = dye.color().getFireworkColor();
        int[] originalHSB = ModColorHandler.hexToRGBLarge(originalColor);
        int[] dyeHSB = ModColorHandler.hexToRGBLarge(dyeColor);
        int r = (originalHSB[0] * 5 + dyeHSB[0]) / 6;
        int g = (originalHSB[1] * 5 + dyeHSB[1]) / 6;
        int b = (originalHSB[2] * 5 + dyeHSB[2]) / 6;
        int finalColor = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        BlockPatternCapability.recolor(level, pos, finalColor);
    }

    public boolean isBarVisible(ItemStack stack) {
        return !Dye.getDyeFromDyespria(stack).isEmpty();
    }

    public int getBarColor(ItemStack stack) {
        int input = DyespriaItem.getDyespriaUses(stack) - 1;
        int maxInput = 4;
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)DyespriaItem.getDyespriaUses(stack) * 13.0f / 4.0f);
    }

    public void finishColoring(Dye dye, Level level, ItemStack dyespria, BlockPos blockPos, Direction face) {
        int dyeCount;
        int uses = DyespriaItem.getDyespriaUses(dyespria) - 1;
        if (uses <= 0) {
            dyeCount = dye.amount() - 1;
            DyespriaItem.setDyespriaUses(dyespria, 4);
        } else {
            dyeCount = dye.amount();
            DyespriaItem.setDyespriaUses(dyespria, uses);
        }
        ItemStack itemStack = Dye.stackFromDye(new Dye(dye.color(), dyeCount));
        Dye.setDyeToDyeHolderStack(dyespria, itemStack, itemStack.getCount(), DyespriaItem.getDyespriaUses(dyespria));
        if (level.isClientSide) {
            this.particles(level.getRandom(), level, dye, blockPos, face);
        }
    }

    public static int getDyespriaUses(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.COLOR, (Object)4);
    }

    public static void setDyespriaUses(ItemStack stack, int uses) {
        stack.set(ModDataComponents.COLOR, (Object)uses);
    }

    private boolean canDye(BlockState blockState, Dye dye) {
        return blockState.hasProperty(ModStateProperties.COLOR) && !((DyeColor)blockState.getValue(ModStateProperties.COLOR)).equals((Object)dye.color()) || !dye.isEmpty();
    }

    public static boolean checkDyedBlock(BlockState blockState) {
        return blockState.is(ModTags.ModBlockTags.DYED);
    }

    private void dyeNonColorableBlock(BlockState blockState, BlockPos blockPos, DyeColor newColor, Level level) {
        BlockEntity blockEntity;
        if (!DyespriaItem.checkDyedBlock(blockState)) {
            return;
        }
        ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
        String modId = location.getNamespace();
        Object blockId = location.getPath();
        if (((String)blockId).equals("candle") || ((String)blockId).equals("shulker_box") || ((String)blockId).equals("terracotta")) {
            blockId = "white_" + (String)blockId;
        }
        if (((String)blockId).equals("glass") || ((String)blockId).equals("glass_pane")) {
            blockId = "white_stained_" + (String)blockId;
        }
        String validColorName = "white|light_gray|gray|black|brown|red|orange|yellow|lime|green|cyan|light_blue|blue|purple|magenta|pink";
        String finalBlockName = ((String)blockId).replaceFirst(validColorName, newColor.getName());
        Block finalBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)finalBlockName));
        BlockState finalBlockState = finalBlock.defaultBlockState();
        BlockEntity originalShulker = level.getBlockEntity(blockPos);
        CompoundTag shulkerData = null;
        if (originalShulker instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity entity = (ShulkerBoxBlockEntity)originalShulker;
            shulkerData = entity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
        }
        if (finalBlock != Blocks.AIR) {
            level.setBlockAndUpdate(blockPos, DyespriaItem.copyAllBlockStateProperties(blockState, finalBlockState));
        }
        if (shulkerData != null && (blockEntity = level.getBlockEntity(blockPos)) instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity newShulkerBox = (ShulkerBoxBlockEntity)blockEntity;
            newShulkerBox.loadFromTag(shulkerData, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public static <T extends Comparable<T>> BlockState copyAllBlockStateProperties(BlockState sourceState, BlockState targetState) {
        for (Property property : sourceState.getProperties()) {
            if (!targetState.hasProperty(property)) continue;
            Comparable value = sourceState.getValue(property);
            targetState = (BlockState)targetState.setValue(property, value);
        }
        return targetState;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            if (other.isEmpty()) {
                access.set(this.remove(stack));
                this.playRemoveOneSound((Entity)player);
            } else {
                ItemStack itemStack = this.add(stack, Dye.getDyeFromDyespria(stack), other);
                access.set(itemStack);
                if (itemStack.isEmpty()) {
                    this.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
        Dye.setDyeToDyeHolderStack(destinationStack, dye, amount);
    }

    private ItemStack remove(ItemStack stack) {
        Dye dye = Dye.getDyeFromDyespria(stack);
        int uses = DyespriaItem.getDyespriaUses(stack);
        if (!dye.isEmpty()) {
            Dye.setDyeColorToStack(stack, DyeColor.WHITE, 0);
            ItemStack returnStack = Dye.stackFromDye(new Dye(dye.color(), dye.amount() - (uses == 4 ? 0 : 1)));
            DyespriaItem.setDyespriaUses(stack, 4);
            return returnStack;
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        Dye dye = Dye.getDyeFromDyespria(stack);
        MutableComponent usage = Component.translatableWithFallback((String)"tooltip.dyespria.usage", (String)"Right click with dye to insert \nRight click caulorflower to repaint \nSneak to apply to the whole column \n").withStyle(ChatFormatting.GOLD);
        Stream<String> usageComponents = Arrays.stream(usage.getString().split("\n", -1)).filter(s -> !s.isEmpty()).map(String::trim);
        usageComponents.forEach(s -> components.add((Component)Component.literal((String)s).withStyle(ChatFormatting.GOLD)));
        components.add((Component)Component.empty());
        components.add(DyespriaItem.getCurrentModeComponent(DyespriaItem.getCurrentMode(stack)));
        components.add((Component)Component.empty());
        if (!dye.isEmpty()) {
            MutableComponent name = Component.literal((String)(dye.amount() + " - " + WordUtils.capitalizeFully((String)dye.color().getName().toLowerCase().replaceAll("[^a-z_]", "").replaceAll("_", " ")))).withStyle(Style.EMPTY.withColor(Dye.colorForDye(this, dye.color())));
            components.add((Component)name);
        } else {
            components.add((Component)Component.translatableWithFallback((String)"tooltip.dyespria.empty", (String)"Empty").withStyle(ChatFormatting.GRAY));
        }
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    @Override
    public Map<DyeColor, Integer> colorValues() {
        return (Map)Util.make((Object)Maps.newLinkedHashMap(), dyeColorHexFormatMap -> {
            dyeColorHexFormatMap.put(DyeColor.WHITE, -1);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_GRAY, -6449253);
            dyeColorHexFormatMap.put(DyeColor.GRAY, -12103854);
            dyeColorHexFormatMap.put(DyeColor.BLACK, -14869215);
            dyeColorHexFormatMap.put(DyeColor.BROWN, -8170446);
            dyeColorHexFormatMap.put(DyeColor.RED, -3254199);
            dyeColorHexFormatMap.put(DyeColor.ORANGE, -485835);
            dyeColorHexFormatMap.put(DyeColor.YELLOW, -4525);
            dyeColorHexFormatMap.put(DyeColor.LIME, -8337633);
            dyeColorHexFormatMap.put(DyeColor.GREEN, -10585066);
            dyeColorHexFormatMap.put(DyeColor.CYAN, -13194868);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_BLUE, -9381404);
            dyeColorHexFormatMap.put(DyeColor.BLUE, -12102740);
            dyeColorHexFormatMap.put(DyeColor.PURPLE, -5152830);
            dyeColorHexFormatMap.put(DyeColor.MAGENTA, -2984263);
            dyeColorHexFormatMap.put(DyeColor.PINK, -479036);
        });
    }

    public static DyespriaMode getCurrentMode(ItemStack itemStack) {
        return (DyespriaMode)((Object)itemStack.getOrDefault(ModDataComponents.DYESPRIA_MODE.get(), (Object)DyespriaMode.SINGLE));
    }

    public static Component getCurrentModeComponent(DyespriaMode dyespriaMode) {
        MutableComponent baseText = Component.translatable((String)"message.more_sniffer_flowers.dyespria_mode").append(": ").withStyle(ChatFormatting.GOLD);
        MutableComponent modeText = Component.literal((String)dyespriaMode.getSerializedName()).withStyle(dyespriaMode.getTextColor());
        return baseText.append((Component)modeText);
    }

    public void changeMode(ServerPlayer player, ItemStack stack, int amount) {
        DyespriaMode currentMode = (DyespriaMode)((Object)stack.getOrDefault(ModDataComponents.DYESPRIA_MODE, (Object)DyespriaMode.SINGLE));
        DyespriaMode newMode = DyespriaMode.shift(currentMode, amount);
        stack.set(ModDataComponents.DYESPRIA_MODE, (Object)newMode);
        player.displayClientMessage(DyespriaItem.getCurrentModeComponent(DyespriaMode.byIndex(newMode.ordinal())), true);
    }
}

