/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.List;
import net.abraxator.moresnifferflowers.blocks.GiantCropBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public class GiantCropItem
extends BlockItem {
    public GiantCropItem(Block pBlock, Item.Properties properties) {
        super(pBlock, properties);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        Level level = context.getLevel();
        BlockPos clickPos = context.getClickedPos().relative(context.getClickedFace(), 1);
        AABB aabb = AABB.ofSize((Vec3)clickPos.getCenter(), (double)2.0, (double)2.0, (double)2.0);
        IMultiBlock multiBlock = (IMultiBlock)state.getBlock();
        multiBlock.fullBlockShape(clickPos, null).forEach(pos -> {
            boolean isWaterLogged = context.getLevel().getFluidState(pos).getType() == Fluids.WATER;
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)this.getBlock().defaultBlockState().setValue((Property)AbstractMultiBlock.CENTER, (Comparable)Boolean.valueOf(pos.equals((Object)clickPos)))).setValue((Property)GiantCropBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged)));
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)patt0$temp;
                entity.setCenter(clickPos);
            }
        });
        return true;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        IMultiBlock multiBlock = (IMultiBlock)state.getBlock();
        AABB aabb = AABB.ofSize((Vec3)context.getClickedPos().relative(context.getClickedFace(), 1).getCenter(), (double)2.0, (double)2.0, (double)2.0);
        boolean ret = multiBlock.fullBlockShape(pos.relative(context.getClickedFace()), null).allMatch(blockPos -> level.getBlockState(blockPos).canBeReplaced());
        return ret;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        components.add((Component)Component.literal((String)"CREATIVE ONLY").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
    }
}

