/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.blocks.Bonmeelable;
import net.abraxator.moresnifferflowers.blocks.GiantCropBlock;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class JarOfBonmeelItem
extends Item {
    public JarOfBonmeelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Bonmeelable bonmeelable;
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = context.getLevel().getBlockState(blockPos);
        Player player = context.getPlayer();
        if (blockState.is(ModTags.ModBlockTags.BONMEELABLE) && (bonmeelable = (Bonmeelable)GiantCropBlock.getCropMap().get(blockState.getBlock()).getA()).canBonmeel(blockPos, blockState, level) && player != null) {
            bonmeelable.performBonmeel(blockPos, blockState, level, player);
            if (!player.isCreative()) {
                player.setItemInHand(context.getHand(), ItemUtils.createFilledResult((ItemStack)player.getItemInHand(context.getHand()), (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag pIsAdvanced) {
        super.appendHoverText(stack, context, components, pIsAdvanced);
        MutableComponent component = Component.translatableWithFallback((String)"tooltip.jar_of_bonmeel.usage", (String)"Can be applied to a 3x3 grid of the following crops: carrot, potato, wheat, beetroot and nether wart").withStyle(ChatFormatting.GOLD);
        Stream<String> usageComponents = Arrays.stream(component.getString().split("\n", -1)).filter(s -> !s.isEmpty()).map(String::trim);
        usageComponents.forEach(s -> components.add((Component)Component.literal((String)s).withStyle(ChatFormatting.GOLD)));
    }
}

