/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.ArrayList;
import java.util.List;
import net.abraxator.moresnifferflowers.capability.NutritionCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.RootedSoup;
import net.abraxator.moresnifferflowers.init.ModDataAttachments;
import net.abraxator.moresnifferflowers.init.ModDataComponents;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class RootedSoupItem
extends Item {
    public RootedSoupItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        int uses;
        Player player = (Player)livingEntity;
        FoodData foodData = player.getFoodData();
        RootedSoup soup = (RootedSoup)stack.get(ModDataComponents.ROOTED_SOUP);
        if (soup == null) {
            return stack;
        }
        int food = soup.food();
        float sat = soup.saturation();
        List rootedEffects = (List)stack.get(ModDataComponents.ROOTED_EFFECTS);
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        if (rootedEffects != null) {
            for (RootedSoup.RootedEffect rootedEffect : rootedEffects) {
                int id = rootedEffect.id();
                int dur = rootedEffect.length();
                int amp = rootedEffect.amplifier();
                boolean positive = rootedEffect.isPositive();
                ((NutritionCapability)player.getData(ModDataAttachments.NUTRITION)).unlockedEffects.add(NutritionCapability.idFromNutrition(NutritionType.byId(id), positive));
                Holder<MobEffect> mobEffect = NutritionType.getEffect(NutritionType.byId(id), positive);
                if (mobEffect == null) continue;
                effects.add(new MobEffectInstance(mobEffect, dur, amp));
            }
        }
        foodData.eat(food, sat);
        if (!level.isClientSide) {
            for (MobEffectInstance mobEffectInstance : effects) {
                player.addEffect(mobEffectInstance);
            }
        }
        if ((uses = (Integer)stack.getOrDefault(ModDataComponents.USES, (Object)1) - 1) <= 0) {
            return Items.BOWL.getDefaultInstance();
        }
        List list = (List)stack.getOrDefault(ModDataComponents.ROOTED_INGREDIENTS, new ArrayList());
        for (ItemStack ingredient : list) {
            ((NutritionCapability)player.getData(ModDataAttachments.NUTRITION)).addItem(ingredient.getItem());
        }
        stack.set(ModDataComponents.USES, (Object)uses);
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.USES, (Object)0) > 0;
    }

    public int getBarColor(ItemStack stack) {
        int input = (Integer)stack.getOrDefault(ModDataComponents.USES, (Object)0);
        RootedSoup soup = (RootedSoup)stack.get(ModDataComponents.ROOTED_SOUP);
        if (soup == null) {
            return 0;
        }
        int maxInput = soup.maxUses();
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public int getBarWidth(ItemStack stack) {
        int input = (Integer)stack.getOrDefault(ModDataComponents.USES, (Object)0);
        RootedSoup soup = (RootedSoup)stack.get(ModDataComponents.ROOTED_SOUP);
        if (soup == null) {
            return 0;
        }
        int maxInput = soup.maxUses();
        return Math.round((float)input / (float)maxInput * 13.0f);
    }
}

