/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.mixins;

import java.util.Objects;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Shadow
    protected FoodData foodData;

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    public void blandEffectInject(Level level, ItemStack food, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> cir) {
        Player player = (Player)this;
        if (player.hasEffect(ModEffects.BLAND)) {
            int amplifier = Objects.requireNonNull(player.getEffect(ModEffects.BLAND)).getAmplifier() + 1;
            float division = 1.0f + (float)amplifier / 2.0f;
            float hungerChance = 0.2f + (float)amplifier / 10.0f;
            if (!level.isClientSide && level.random.nextFloat() < hungerChance) {
                player.addEffect(new MobEffectInstance(MobEffects.HUNGER, Math.round(10.0f * division) * 20, amplifier - 1));
            }
            FoodProperties foodproperties = food.getFoodProperties((LivingEntity)player);
            int foodValue = Math.round((float)foodproperties.nutrition() / division);
            float satValue = foodproperties.saturation() / division;
            this.foodData.eat(-(foodproperties.nutrition() - foodValue), -(foodproperties.saturation() - satValue));
        }
    }
}

