/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.abraxator.moresnifferflowers.init.ModRecipeSerializers;
import net.abraxator.moresnifferflowers.init.ModRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public record CropressingRecipe(Ingredient ingredient, int count, ItemStack result) implements Recipe<SingleRecipeInput>
{
    public static final MapCodec<CropressingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(CropressingRecipe::ingredient), (App)Codec.INT.fieldOf("count").forGetter(CropressingRecipe::count), (App)ItemStack.CODEC.fieldOf("result").forGetter(CropressingRecipe::result)).apply((Applicative)builder, CropressingRecipe::new));

    public boolean matches(SingleRecipeInput pInput, Level level) {
        ItemStack itemStack = pInput.getItem(0);
        return itemStack.getCount() >= this.count && this.ingredient.test(itemStack.copyWithCount(1));
    }

    public ItemStack assemble(SingleRecipeInput pInput, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CROPRESSING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CROPRESSING.get();
    }
}

