/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.vivicus;

import javax.annotation.Nullable;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

public class VivicusTreeGrower {
    private final String name;
    private final ResourceKey<ConfiguredFeature<?, ?>> cured_tree;
    private final ResourceKey<ConfiguredFeature<?, ?>> corrupted_tree;

    public VivicusTreeGrower(String name, ResourceKey<ConfiguredFeature<?, ?>> cured_tree, ResourceKey<ConfiguredFeature<?, ?>> corrupted_tree) {
        this.name = name;
        this.cured_tree = cured_tree;
        this.corrupted_tree = corrupted_tree;
    }

    @Nullable
    private ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeature(RandomSource random, BlockState saplingState) {
        return (Boolean)saplingState.getValue((Property)ModStateProperties.VIVICUS_CURED) == false ? this.corrupted_tree : this.cured_tree;
    }

    public boolean growTree(ServerLevel level, ChunkGenerator pChunkGenerator, BlockPos pos, BlockState saplingState, RandomSource random) {
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey1 = this.getConfiguredFeature(random, saplingState);
        if (resourcekey1 == null) {
            return false;
        }
        Holder holder1 = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(resourcekey1).orElse(null);
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)holder1);
        holder1 = event.getFeature();
        if (event.isCanceled()) {
            return false;
        }
        if (holder1 == null) {
            return false;
        }
        ConfiguredFeature configuredfeature1 = (ConfiguredFeature)holder1.value();
        BlockState blockstate1 = level.getFluidState(pos).createLegacyBlock();
        if (configuredfeature1.place((WorldGenLevel)level, pChunkGenerator, random, pos)) {
            if (level.getBlockState(pos) == blockstate1) {
                level.sendBlockUpdated(pos, saplingState, blockstate1, 2);
            }
            return true;
        }
        level.setBlock(pos, saplingState, 4);
        return false;
    }
}

