/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.vivicus;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class VivicusTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<VivicusTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(p_338099_ -> VivicusTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)p_338099_).apply((Applicative)p_338099_, VivicusTrunkPlacer::new));

    public VivicusTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.VIVICUS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int pFreeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> ret = new ArrayList<FoliagePlacer.FoliageAttachment>();
        LinkedHashMap blocks = new LinkedHashMap();
        int lastLogHeight = pFreeTreeHeight - (int)Mth.randomBetween((RandomSource)random, (float)2.0f, (float)3.0f);
        BlockPos.MutableBlockPos mainTrunk = pos.mutable();
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            this.placeLog(level, blockSetter, random, (BlockPos)mainTrunk, config);
            if (i == 0) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    int j;
                    int outerHeight = random.nextInt(3);
                    int cornerHeight = outerHeight + (random.nextInt(2) - 1);
                    int innerHeight = Math.min(outerHeight + random.nextIntBetweenInclusive(5, 7), pFreeTreeHeight - 1);
                    if (!(random.nextDouble() <= 0.9)) continue;
                    BlockPos blockPosInner = pos.relative(direction);
                    for (int j2 = 0; j2 < innerHeight; ++j2) {
                        this.placeLog(level, blockSetter, random, blockPosInner.above(j2), config);
                    }
                    if (random.nextDouble() <= 0.8) {
                        ret.add(new FoliagePlacer.FoliageAttachment(blockPosInner.above(innerHeight), 4, false));
                    }
                    if (random.nextDouble() <= 0.9) {
                        BlockPos blockPosCorner = blockPosInner.relative(random.nextDouble() > 0.5 ? direction.getClockWise() : direction.getCounterClockWise());
                        for (j = 0; j < cornerHeight; ++j) {
                            this.placeLog(level, blockSetter, random, blockPosCorner.above(j), config);
                        }
                    }
                    if (!(random.nextDouble() <= 0.9)) continue;
                    BlockPos blockPosOuter = blockPosInner.relative(direction);
                    for (j = 0; j < outerHeight; ++j) {
                        this.placeLog(level, blockSetter, random, blockPosOuter.above(j), config);
                    }
                }
            }
            mainTrunk.move(Direction.UP);
        }
        ret.add(new FoliagePlacer.FoliageAttachment(mainTrunk.below(1), 0, false));
        return ret;
    }

    private void placeStump(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos stumpPos, TreeConfiguration config) {
        if (random.nextDouble() <= 0.3) {
            for (int height = 0; height < random.nextInt(3); ++height) {
                this.placeLog(level, blockSetter, random, stumpPos.immutable().above(height), config);
            }
        }
    }

    protected boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return super.validTreePos(level, pos) || level.isStateAtPosition(pos, blockState -> blockState.is(ModTags.ModBlockTags.VIVICUS_TREE_REPLACABLE));
    }
}

