/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.abraxator.moresnifferflowers.blockentities.IModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.BerootCauldronBlock;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.BetterNonNullList;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.BerootCauldronSuckPacket;
import net.abraxator.moresnifferflowers.networking.toServer.BerootCauldronCraftPacket;
import net.abraxator.moresnifferflowers.nutrition.Nutrition;
import net.abraxator.moresnifferflowers.nutrition.NutritionEntry;
import net.abraxator.moresnifferflowers.nutrition.NutritionType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.nikdo53.tinymultiblocklib.blockentities.AbstractMultiBlockEntity;
import org.jetbrains.annotations.Nullable;

public class BerootCauldronBlockEntity
extends AbstractMultiBlockEntity
implements IModBlockEntity {
    public int beetroots = 0;
    private final int foodLimit = 8;
    public BetterNonNullList<ItemStack> ingredients = BetterNonNullList.withSize(8, ItemStack.f_41583_);
    public int itemRot = 0;
    public ItemStack soup = ItemStack.f_41583_;
    public int soupCount = 0;
    public boolean isCrafted = false;
    public final int MAX_SOUP_COUNT = 6;
    private final int beetrootLimit = 4;
    private final int spoonSpeed = 10;
    int spoonRotation = 0;
    public boolean redSoup = true;
    boolean crafting = false;
    int craftingTimeRemaining = 0;

    public BerootCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BEROOT_CAULDRON.get(), pos, state);
    }

    public InteractionResult addItem(ItemStack itemStack, Player player) {
        if (itemStack.m_150930_((Item)ModItems.CROPRESSED_BEETROOT.get()) && this.beetroots < 4 && !this.isCrafted) {
            this.addBeetroot(itemStack, player);
            this.redSoup = true;
        } else if (!(itemStack.m_41619_() || this.ingredients.isFull() || Nutrition.getNutritionForItem(itemStack.m_41720_()).isEmpty() || this.isCrafted || this.beetroots <= 0)) {
            this.addIngredient(itemStack, player);
            this.redSoup = false;
        } else {
            if (itemStack.m_150930_(Items.f_42399_) && this.isCrafted) {
                return this.giveSoup(itemStack, player);
            }
            if (!this.ingredients.isFullyDefault() && !this.isCrafted && player != null) {
                this.crafting = true;
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void craft() {
        if (this.ingredients.isFullyDefault()) {
            return;
        }
        this.isCrafted = true;
        HashMap map = new HashMap();
        ItemStack soup = ((Item)ModItems.ROOTED_SOUP.get()).m_7968_();
        CompoundTag tag = new CompoundTag();
        int neutral = 0;
        this.ingredients.validStream().forEach(stack -> {
            Nutrition nutrition = Nutrition.getNutritionForItem(stack.m_41720_());
            nutrition.getNutritionEntries().forEach(entry -> map.merge(entry.nutrition(), entry.weight(), Integer::sum));
        });
        ArrayList<NutritionEntry> entryList = new ArrayList<NutritionEntry>(map.entrySet().stream().map(entry -> new NutritionEntry((NutritionType)((Object)((Object)entry.getKey())), (Integer)entry.getValue())).sorted(Comparator.comparing(NutritionEntry::weight)).toList());
        int sat = this.ingredients.validStream().filter(itemStack -> itemStack.getFoodProperties(null) != null).mapToInt(value -> (int)value.getFoodProperties(null).m_38745_()).sum();
        int food = this.ingredients.validStream().filter(itemStack -> itemStack.getFoodProperties(null) != null).mapToInt(value -> value.getFoodProperties(null).m_38744_()).sum();
        int ingredients = this.ingredients.getValidSize();
        this.soupCount = this.beetroots + ingredients / 4;
        int soupFood = 6 + food / ingredients;
        float soupSat = 7.0f + (float)sat / (float)ingredients;
        for (NutritionEntry nutritionEntry : entryList) {
            if (!nutritionEntry.nutrition().equals((Object)NutritionType.NEUTRAL)) continue;
            neutral += nutritionEntry.weight();
        }
        int maxSoupUses = 6;
        int soupUses = Math.min(Math.max(Math.round((float)food / 3.0f) + (ingredients - 4) / 2, 1), maxSoupUses);
        ListTag ingredientListTag = new ListTag();
        for (ItemStack stack2 : this.ingredients.validStream().toList()) {
            CompoundTag ingredientTag = new CompoundTag();
            stack2.m_41739_(ingredientTag);
            ingredientListTag.add((Object)ingredientTag);
        }
        tag.m_128365_("ingredients", (Tag)ingredientListTag);
        tag.m_128405_("soupFood", soupFood);
        tag.m_128350_("soupSat", soupSat);
        tag.m_128405_("soupCount", soupUses);
        tag.m_128405_("soupCountMax", soupUses);
        tag.m_128405_("color", ModColorHandler.RGBtoInt(this.color()));
        float positiveThreshold = 0.5f;
        float negativeThreshold = 0.75f;
        float perfectMix = (positiveThreshold + negativeThreshold) / 2.0f;
        int maxAmp = 4;
        float ampThresholds = (perfectMix - positiveThreshold) / (float)maxAmp;
        int minDuration = 1200;
        int duration = minDuration + neutral / 100 * 60 * 20;
        int totalFlavour = 0;
        int blandThreshold = 120;
        int minFlavour = 50;
        ListTag effectTag = new ListTag();
        for (NutritionEntry nutritionEntry : entryList) {
            if (nutritionEntry.nutrition().equals((Object)NutritionType.NEUTRAL)) continue;
            totalFlavour += nutritionEntry.weight();
            float ratio = (float)nutritionEntry.weight() / ((float)neutral + 1.0f);
            int amplifier = 1;
            Boolean positive = null;
            if (ratio > negativeThreshold) {
                amplifier = Math.round((ratio - negativeThreshold) / ampThresholds);
                positive = false;
                duration /= 2;
            } else if (ratio > positiveThreshold) {
                positive = true;
                amplifier = maxAmp;
                float inaccuracy = Mth.m_14154_((float)(ratio - perfectMix));
                amplifier -= Math.round(inaccuracy / ampThresholds);
            }
            amplifier = Math.max(Math.min(amplifier, maxAmp), 1);
            if (positive == null || nutritionEntry.weight() < minFlavour) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("nutritionType", nutritionEntry.nutrition().ordinal());
            compoundTag.m_128379_("positive", positive.booleanValue());
            compoundTag.m_128405_("dur", duration);
            compoundTag.m_128405_("amp", amplifier);
            effectTag.add((Object)compoundTag);
        }
        if (effectTag.isEmpty()) {
            if (totalFlavour < blandThreshold) {
                compoundTag = new CompoundTag();
                compoundTag.m_128405_("nutritionType", NutritionType.NEUTRAL.ordinal());
                compoundTag.m_128379_("positive", false);
                compoundTag.m_128405_("dur", duration);
                compoundTag.m_128405_("amp", 1);
                effectTag.add((Object)compoundTag);
            } else {
                compoundTag = new CompoundTag();
                compoundTag.m_128405_("nutritionType", NutritionType.NEUTRAL.ordinal());
                compoundTag.m_128379_("positive", true);
                compoundTag.m_128405_("dur", duration);
                compoundTag.m_128405_("amp", Math.min(Mth.m_14143_((float)((float)(totalFlavour - blandThreshold) / 100.0f + 1.0f)), 3));
                effectTag.add((Object)compoundTag);
            }
        }
        tag.m_128365_("effects", (Tag)effectTag);
        soup.m_41751_(tag);
        this.soup = soup;
        this.m_6596_();
    }

    @Override
    public void tick(Level level) {
        if (this.isCenter()) {
            this.suckInItems(level, this.center);
        }
    }

    @Override
    public void clientTick(ClientLevel level) {
        if (!this.isCenter()) {
            return;
        }
        ++this.itemRot;
        if (this.crafting && this.craftingTimeRemaining < 9) {
            ++this.spoonRotation;
            ++this.craftingTimeRemaining;
            this.itemRot += 10;
            if (this.spoonRotation * 10 >= this.soupCount * 180 && this.soupCount != 0) {
                ModPacketHandler.CHANNEL.sendToServer((Object)new BerootCauldronCraftPacket(this.center));
                this.craft();
                this.crafting = false;
                this.isCrafted = true;
                this.craftingTimeRemaining = 0;
                this.spoonRotation %= 36;
                Vec3 center = this.getMiddle();
                for (int i = 0; i < 360; ++i) {
                    if (i % 20 != 0) continue;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, center.f_82479_, center.f_82480_, center.f_82481_, (double)Mth.m_14089_((float)i), 0.5, (double)Mth.m_14031_((float)i));
                }
            }
        } else {
            this.crafting = false;
            this.craftingTimeRemaining = 0;
        }
    }

    private boolean valuesClose(List<NutritionEntry> entryList, int tolerance) {
        List<Integer> weights = entryList.stream().map(NutritionEntry::weight).toList();
        int min = Collections.min(weights);
        int max = Collections.max(weights);
        return max - min <= tolerance;
    }

    public boolean hasSoup() {
        return this.soupCount > 0 && !this.soup.equals(ItemStack.f_41583_);
    }

    private InteractionResult giveSoup(ItemStack itemStack, Player player) {
        boolean isServer;
        boolean b = !this.hasSoup();
        boolean b1 = !this.isCrafted;
        boolean bl = isServer = !this.f_58857_.f_46443_;
        if (b || b1) {
            return InteractionResult.FAIL;
        }
        itemStack.m_41774_(1);
        ItemStack soup1 = this.soup.m_41777_();
        player.m_21008_(InteractionHand.MAIN_HAND, ItemUtils.m_41817_((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND), (Player)player, (ItemStack)soup1, (boolean)false));
        --this.soupCount;
        if (this.soupCount <= 0) {
            this.soup = ItemStack.f_41583_;
            this.clearIngredients();
        }
        this.m_6596_();
        return InteractionResult.SUCCESS;
    }

    private void addIngredient(ItemStack itemStack, Player player) {
        this.ingredients.set(this.ingredients.getFirstEmptySlot(), new ItemStack((ItemLike)itemStack.m_41720_(), 1));
        int ingredients = this.ingredients.getValidSize();
        this.soupCount = this.beetroots + ingredients / 4;
        if (this.f_58857_.f_46443_) {
            Vec3 center = this.getMiddle();
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(this.color(itemStack.m_41720_()).m_82490_(0.00392156862745098).m_252839_(), 1.0f), center.f_82479_, center.f_82480_, center.f_82481_, (double)Mth.m_14089_((float)i), 0.5, (double)Mth.m_14031_((float)i));
            }
        }
        itemStack.m_41774_(1);
        this.m_6596_();
    }

    private void addBeetroot(ItemStack itemStack, Player player) {
        ++this.beetroots;
        int ingredients = this.ingredients.getValidSize();
        this.soupCount = this.beetroots + ingredients / 4;
        itemStack.m_41774_(1);
        if (!this.f_58857_.f_46443_) {
            return;
        }
        Vec3 center = this.getMiddle();
        for (int i = 0; i < 360; ++i) {
            if (i % 20 != 0) continue;
            this.f_58857_.m_7106_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)16007990).m_252839_(), 1.0f), center.f_82479_, center.f_82480_, center.f_82481_, (double)Mth.m_14089_((float)i), 0.5, (double)Mth.m_14031_((float)i));
        }
        this.m_6596_();
    }

    public void suckInItems(Level level, BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch ((Direction)level.m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case EAST: {
                ++x;
                break;
            }
            case NORTH: {
                ++x;
                --z;
                break;
            }
            case WEST: {
                --z;
            }
        }
        for (ItemEntity itementity : BerootCauldronBlockEntity.getItemsAtAndAbove(level, new BlockPos(x, y, z))) {
            ItemStack itemStack = itementity.m_32055_().m_41777_();
            ItemStack itemStack1 = itemStack.m_41777_();
            if (!this.addItem(itemStack, null).equals((Object)InteractionResult.SUCCESS)) continue;
            ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BerootCauldronSuckPacket(itemStack1, this.m_58899_()));
            itementity.m_32045_(itemStack);
        }
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level level, BlockPos pos) {
        return BerootCauldronBlock.SHAPE_INSIDE.m_83299_().stream().flatMap(p_155558_ -> level.m_6443_(ItemEntity.class, p_155558_.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_() + 1.125), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    public float getItemsRotation(float partialTick) {
        if (this.crafting) {
            partialTick *= 10.0f;
        }
        return ((float)this.itemRot + partialTick) * 2.0f;
    }

    public float getSpoonRotation(float partialTick) {
        if (this.crafting && this.spoonRotation % 9 != 0) {
            return ((float)this.spoonRotation + partialTick) * 10.0f;
        }
        return this.spoonRotation * 10;
    }

    private Vec3 getMiddle() {
        float x = -0.5f;
        float y = 1.5f;
        float z = 0.5f;
        switch ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case EAST: {
                x += 1.0f;
                break;
            }
            case NORTH: {
                x += 1.0f;
                z -= 1.0f;
                break;
            }
            case WEST: {
                z -= 1.0f;
            }
        }
        return this.center.m_252807_().m_82520_((double)x, (double)y, (double)z);
    }

    public void clearIngredients() {
        this.ingredients.clear();
        this.beetroots = 0;
        this.isCrafted = false;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.isCenter()) {
            return;
        }
        tag.m_128405_("beetroots", this.beetroots);
        ListTag items = new ListTag();
        Iterator iterator = this.ingredients.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            items.add((Object)itemTag);
        }
        tag.m_128365_("ingredients", (Tag)items);
        tag.m_128405_("soupCount", this.soupCount);
        tag.m_128379_("crafting", this.crafting);
        tag.m_128405_("craftingTime", this.craftingTimeRemaining);
        tag.m_128379_("isCrafted", this.isCrafted);
        tag.m_128379_("redSoup", this.redSoup);
        tag.m_128405_("spoonRotation", this.spoonRotation);
        if (!this.soup.m_41619_()) {
            CompoundTag soupTag = new CompoundTag();
            this.soup.m_41739_(soupTag);
            tag.m_128365_("soup", (Tag)soupTag);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!this.isCenter()) {
            return;
        }
        this.ingredients.clear();
        this.beetroots = tag.m_128451_("beetroots");
        ListTag ingredientsTag = tag.m_128437_("ingredients", 10);
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (i < ingredientsTag.size()) {
                CompoundTag itemTag = ingredientsTag.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                this.ingredients.set(i, stack);
                continue;
            }
            this.ingredients.set(i, ItemStack.f_41583_);
        }
        this.soupCount = tag.m_128451_("soupCount");
        this.crafting = tag.m_128471_("crafting");
        this.craftingTimeRemaining = tag.m_128451_("craftingTime");
        this.isCrafted = tag.m_128471_("isCrafted");
        this.redSoup = tag.m_128471_("redSoup");
        this.spoonRotation = tag.m_128451_("spoonRotation");
        boolean soup1 = tag.m_128441_("soup");
        if (soup1) {
            this.soup = ItemStack.m_41712_((CompoundTag)tag.m_128469_("soup"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Vec3 color() {
        return this.color(Items.f_41852_);
    }

    public Vec3 color(Item item) {
        int loop;
        int r = 0;
        int g = 0;
        int b = 0;
        Item latestIngredient = Items.f_41852_;
        if (!this.ingredients.isFullyDefault()) {
            latestIngredient = this.ingredients.getLastValid().m_41720_();
        }
        if (!item.equals(Items.f_41852_)) {
            latestIngredient = item;
        }
        int n = loop = this.isCrafted ? this.ingredients.size() : 1;
        if (!latestIngredient.equals(Items.f_41852_)) {
            block7: for (int i = 0; i < loop; ++i) {
                if (this.isCrafted) {
                    latestIngredient = ((ItemStack)this.ingredients.get(i)).m_41720_();
                }
                if (latestIngredient.equals(Items.f_41852_)) continue;
                NutritionType nutritionType = Nutrition.getLargestNutrition(latestIngredient);
                switch (nutritionType) {
                    case SOUR: {
                        r += 255;
                        g += 205;
                        b += 0;
                        continue block7;
                    }
                    case SALTY: {
                        r += 190;
                        g += 233;
                        b += 233;
                        continue block7;
                    }
                    case SPICY: {
                        r += 187;
                        g += 67;
                        b += 48;
                        continue block7;
                    }
                    case SWEET: {
                        r += 230;
                        g += 120;
                        b += 150;
                        continue block7;
                    }
                    case NEUTRAL: {
                        r += 140;
                        g += 102;
                        b += 30;
                    }
                }
            }
        }
        if (this.isCrafted && !this.ingredients.isFullyDefault()) {
            r /= this.ingredients.getValidSize();
            g /= this.ingredients.getValidSize();
            b /= this.ingredients.getValidSize();
        }
        if (this.redSoup && item.equals(Items.f_41852_) && !this.isCrafted) {
            r = 164;
            g = 39;
            b = 44;
        }
        return new Vec3((double)r, (double)g, (double)b);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public AABB getRenderBoundingBox() {
        return AABB.m_165882_((Vec3)this.center.m_252807_(), (double)4.0, (double)4.0, (double)4.0);
    }
}

