/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.cropressor.CropressorBlockBase;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.BetterNonNullList;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModRecipeTypes;
import net.abraxator.moresnifferflowers.init.ModSoundEvents;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.recipes.CropressingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CropressorBlockEntity
extends ModBlockEntity
implements Container {
    public static int SLOT_SIZE = 9;
    public BetterNonNullList<ItemStack> container = BetterNonNullList.withSize(SLOT_SIZE, ItemStack.f_41583_);
    public ItemStack currentCrop = ItemStack.f_41583_;
    public ItemStack result = ItemStack.f_41583_;
    public int progress = 0;
    public final int MAX_PROGRESS = 100;
    private final RecipeManager.CachedCheck<Container, CropressingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)ModRecipeTypes.CROPRESSING.get()));
    public int barLength = 0;

    public CropressorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CROPRESSOR.get(), pos, state);
    }

    @Override
    public void tick(Level level) {
        long gameTime = level.m_46467_();
        if (this.progress > 0 && gameTime % 3L == 0L) {
            ++this.progress;
            if (this.progress % 20 == 0) {
                level.m_5594_(null, this.f_58858_, (SoundEvent)ModSoundEvents.CROPRESSOR_BELT.get(), SoundSource.BLOCKS, 1.0f, (float)(1.0 + (double)level.m_213780_().m_188501_() * 0.2));
            }
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            if (this.progress >= 100) {
                Vec3 blockPos = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)CropressorBlockBase.f_54117_)).m_122424_()).m_252807_();
                ItemEntity entity = new ItemEntity(level, blockPos.f_82479_, blockPos.f_82480_ + 0.5, blockPos.f_82481_, this.result);
                this.result = ItemStack.f_41583_;
                if (this.barLength >= 8) {
                    this.barLength = 0;
                }
                level.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 1.0f);
                level.m_7967_((Entity)entity);
                level.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
                this.progress = 0;
                this.m_6596_();
            }
        }
        if (gameTime % 10L != 0L) {
            return;
        }
        if (gameTime % 20L == 0L) {
            this.suckInItems(level);
        }
        if (this.container.isFullyDefault()) {
            return;
        }
        if (this.progress <= 0) {
            for (int slot = 0; slot < SLOT_SIZE; ++slot) {
                ItemStack slotStack = (ItemStack)this.container.get(slot);
                if (slotStack.m_41619_()) continue;
                SimpleContainer recipeInput = new SimpleContainer(new ItemStack[]{slotStack});
                Optional cropressingRecipeOptional = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CROPRESSING.get(), (Container)recipeInput, level);
                cropressingRecipeOptional.ifPresent(recipe -> {
                    if (slotStack.m_41613_() >= recipe.count()) {
                        this.result = recipe.result();
                        slotStack.m_41774_(recipe.count());
                    }
                });
                if (this.result.m_41619_()) continue;
                ++this.progress;
                this.m_6596_();
                return;
            }
        }
    }

    public boolean canInteract() {
        return true;
    }

    public InteractionResult addItem(ItemStack stack) {
        boolean success = false;
        ItemStack copy = stack.m_41777_();
        if (stack.m_204117_(ModTags.ModItemTags.CROPRESSABLE)) {
            if (this.m_18949_(Set.of(stack.m_41720_()))) {
                for (int slot = 0; slot < SLOT_SIZE && !stack.m_41619_(); ++slot) {
                    ItemStack slotStack = (ItemStack)this.container.get(slot);
                    int space = 64 - slotStack.m_41613_();
                    if (!slotStack.m_150930_(stack.m_41720_()) || space <= 0) continue;
                    ItemStack split = stack.m_41620_(space);
                    slotStack.m_41769_(split.m_41613_());
                    this.container.set(slot, slotStack);
                    success = true;
                }
            }
            if (!stack.m_41619_() && this.container.getValidSize() < SLOT_SIZE) {
                this.container.set(this.container.getFirstEmptySlot(), stack.m_41777_());
                stack.m_41774_(stack.m_41613_());
                success = true;
            }
            if (success) {
                this.currentCrop = new ItemStack((ItemLike)copy.m_41720_(), this.getTotalAmount(copy.m_41720_()));
                this.barLength = Math.min(Mth.m_14167_((float)((float)this.getTotalAmount(copy.m_41720_()) / 2.0f)), 8);
                this.m_6596_();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getTotalAmount(Item item) {
        int amount = 0;
        for (int slot = 0; slot < SLOT_SIZE; ++slot) {
            ItemStack stack = (ItemStack)this.container.get(slot);
            if (!stack.m_150930_(item)) continue;
            amount += stack.m_41613_();
        }
        return amount;
    }

    public void suckInItems(Level level) {
        Direction direction1;
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos pos = this.f_58858_.m_121945_(direction).m_7494_();
        Container container = HopperBlockEntity.m_59390_((Level)level, (BlockPos)pos);
        if (container != null && !CropressorBlockEntity.isEmptyContainer(container, direction1 = Direction.DOWN)) {
            CropressorBlockEntity.getSlots(container, direction1).anyMatch(slot -> this.tryTakeInItemFromSlot(container, slot, direction1));
        }
    }

    private static boolean isEmptyContainer(Container container, Direction direction) {
        return CropressorBlockEntity.getSlots(container, direction).allMatch(slot -> container.m_8020_(slot).m_41619_());
    }

    private static IntStream getSlots(Container container, Direction direction) {
        return container instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)container).m_7071_(direction)) : IntStream.range(0, container.m_6643_());
    }

    private boolean tryTakeInItemFromSlot(Container container, int slot, Direction direction) {
        ItemStack originalStack = container.m_8020_(slot);
        if (!originalStack.m_41619_() && this.canTakeItemFromContainer(container, originalStack, slot, direction)) {
            ItemStack newStack = originalStack.m_41777_();
            this.addItem(newStack);
            if (newStack.m_41613_() != originalStack.m_41613_()) {
                container.m_6596_();
            }
            container.m_6836_(slot, newStack);
            return true;
        }
        return false;
    }

    private boolean canTakeItemFromContainer(Container destination, ItemStack itemStack, int slot, Direction direction) {
        return true;
    }

    public int getColor() {
        Item item = this.currentCrop.m_41720_();
        if (item.equals(Items.f_41852_)) {
            return 0;
        }
        if (item.equals(Items.f_42620_)) {
            return 12094540;
        }
        if (item.equals(Items.f_42619_)) {
            return 16752949;
        }
        if (item.equals(Items.f_42588_)) {
            return 10369323;
        }
        if (item.equals(Items.f_42732_)) {
            return 12806246;
        }
        if (item.equals(Items.f_42405_)) {
            return 16773982;
        }
        int hash = item.toString().hashCode();
        double r = (hash & 0xFF0000) >> 16;
        double g = (hash & 0xFF00) >> 8;
        double b = hash & 0xFF;
        return ModColorHandler.RGBtoInt(new Vec3(r, g, b));
    }

    public int m_6643_() {
        return SLOT_SIZE;
    }

    public boolean m_7983_() {
        return this.container.isFullyDefault();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.container.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = (ItemStack)this.container.get(slot);
        this.m_6596_();
        return stack.m_41620_(amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.container.setDefault(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.container.set(slot, stack);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.container.clear();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("content", (Tag)this.currentCrop.m_41739_(new CompoundTag()));
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("bar", this.barLength);
        tag.m_128365_("result", (Tag)this.result.m_41739_(new CompoundTag()));
        ListTag items = new ListTag();
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            items.add((Object)itemTag);
        }
        tag.m_128365_("container", (Tag)items);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.currentCrop = ItemStack.m_41712_((CompoundTag)tag.m_128469_("content"));
        this.progress = tag.m_128451_("progress");
        this.barLength = tag.m_128451_("bar");
        this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
        ListTag containerTag = tag.m_128437_("container", 10);
        for (int i = 0; i < SLOT_SIZE; ++i) {
            CompoundTag itemTag = containerTag.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            this.container.set(i, stack);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        this.m_183515_(compoundtag);
        return compoundtag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_122030_(2).m_122013_(2).m_6630_(2), this.m_58899_().m_122025_(2).m_122020_(2).m_6625_(2));
    }
}

