/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.google.common.collect.Maps;
import java.util.Map;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ColorableVivicusBlock
extends Colorable {
    default public EnumProperty<DyeColor> getColorProperty() {
        return ModStateProperties.COLOR;
    }

    default public void addDye(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!blockState.m_61138_(this.getColorProperty())) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Dye dye = Dye.getDyeFromDyespria(stack);
        RandomSource randomSource = level.f_46441_;
        if (((DyeColor)blockState.m_61143_(this.getColorProperty())).equals((Object)dye.color()) || dye.isEmpty()) {
            return;
        }
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_(this.getColorProperty(), (Comparable)dye.color()));
        ItemStack itemStack = Dye.stackFromDye(new Dye(dye.color(), dye.amount() - randomSource.m_216332_(0, 1)));
        Dye.setDyeToDyeHolderStack(stack, itemStack, itemStack.m_41613_());
        if (!level.m_5776_()) {
            this.particles(randomSource, (Level)((ServerLevel)level), dye, blockPos);
        }
    }

    default public int getColorId(BlockPlaceContext context) {
        return context.m_43722_().m_41784_().m_128451_("MSF_ID");
    }

    @Nullable
    default public BlockState stateForPlacementHelper(BlockState state, BlockPlaceContext context) {
        if (state != null) {
            return (BlockState)state.m_61124_(ModStateProperties.COLOR, (Comparable)DyeColor.m_41053_((int)this.getColorId(context)));
        }
        return null;
    }

    @NotNull
    default public ItemStack cloneItemStackHelper(BlockState state, ItemStack stack) {
        int colorId = ((DyeColor)state.m_61143_(ModStateProperties.COLOR)).m_41060_();
        int color = this.colorValues().get(DyeColor.m_41053_((int)colorId));
        stack.m_41784_().m_128405_("MSF_Hex", color);
        stack.m_41784_().m_128405_("MSF_ID", colorId);
        return stack;
    }

    @Override
    default public Map<DyeColor, Integer> colorValues() {
        return (Map)Util.m_137469_((Object)Maps.newLinkedHashMap(), dyeColorHexFormatMap -> {
            dyeColorHexFormatMap.put(DyeColor.WHITE, -1);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_GRAY, -2962728);
            dyeColorHexFormatMap.put(DyeColor.GRAY, -5200706);
            dyeColorHexFormatMap.put(DyeColor.BLACK, -8159589);
            dyeColorHexFormatMap.put(DyeColor.BROWN, -2710916);
            dyeColorHexFormatMap.put(DyeColor.RED, -21338);
            dyeColorHexFormatMap.put(DyeColor.ORANGE, -11904);
            dyeColorHexFormatMap.put(DyeColor.YELLOW, -3974);
            dyeColorHexFormatMap.put(DyeColor.LIME, -2228329);
            dyeColorHexFormatMap.put(DyeColor.GREEN, -6094926);
            dyeColorHexFormatMap.put(DyeColor.CYAN, -6553638);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_BLUE, -4259846);
            dyeColorHexFormatMap.put(DyeColor.BLUE, -5779969);
            dyeColorHexFormatMap.put(DyeColor.PURPLE, -3362561);
            dyeColorHexFormatMap.put(DyeColor.MAGENTA, -1462785);
            dyeColorHexFormatMap.put(DyeColor.PINK, -10249);
        });
    }
}

