/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;

public interface ModCropBlock
extends BonemealableBlock {
    public IntegerProperty getAgeProperty();

    default public boolean isMaxAge(BlockState blockState) {
        return this.getAge(blockState) >= this.getMaxAge();
    }

    default public int getMaxAge() {
        return (Integer)this.getAgeProperty().m_6908_().stream().toList().get(this.getAgeProperty().m_6908_().size() - 1);
    }

    default public int getAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.getAgeProperty());
    }

    default public void makeGrowOnTick(BlockState blockState, Level level, BlockPos blockPos) {
        if (((Boolean)blockState.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        if (!this.isMaxAge(blockState) && level.isAreaLoaded(blockPos, 1) && level.m_45524_(blockPos, 0) >= 9) {
            float f = ModCropBlock.getGrowthSpeed(blockState, (BlockGetter)level, blockPos);
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)blockPos, (BlockState)blockState, (level.m_213780_().m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)this.getAgeProperty()) + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        }
    }

    default public void makeGrowOnBonemeal(Level level, BlockPos blockPos, BlockState blockState) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.isMaxAge(blockState) ? this.getAge(blockState) : this.getAge(blockState) + 1)), 2);
    }

    default public boolean mayPlaceOn(BlockState state) {
        return state.m_60713_(Blocks.f_50093_) || state.m_60734_() instanceof FarmBlock || state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("supplementaries", "planters")));
    }

    private static void shear(Player player, Level level, BlockPos blockPos, BlockState blockState, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockPos, player.m_21120_(hand));
        }
        IMultiBlock.getFullShape((Level)level, (BlockPos)blockPos).forEach(pos -> {
            BlockState blockStateNew = level.m_8055_(pos);
            level.m_46597_(pos, (BlockState)blockStateNew.m_263224_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(true)));
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockStateNew));
        });
        level.m_5594_(null, blockPos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        player.m_21120_(hand).m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
    }

    default public boolean shear(Player player, Level level, BlockPos blockPos, InteractionHand hand) {
        BlockState blockState = level.m_8055_(blockPos);
        if (player.m_21120_(hand).m_204117_(Tags.Items.SHEARS) && !((Boolean)blockState.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            ModCropBlock.shear(player, level, blockPos, blockState, hand);
            return true;
        }
        return false;
    }

    public static float getGrowthSpeed(BlockState state, BlockGetter level, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        Block block = state.m_60734_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = level.m_8055_(blockpos.m_7918_(i, 0, j));
                Block block2 = state.m_60734_();
                if (block2 instanceof IPlantable) {
                    IPlantable plantable = (IPlantable)block2;
                    if (blockstate.canSustainPlant(level, blockpos.m_7918_(i, 0, j), Direction.UP, plantable)) {
                        f1 = 1.0f;
                        if (blockstate.isFertile(level, pos.m_7918_(i, 0, j))) {
                            f1 = 3.0f;
                        }
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.m_122012_();
        BlockPos blockpos2 = pos.m_122019_();
        BlockPos blockpos3 = pos.m_122024_();
        BlockPos blockpos4 = pos.m_122029_();
        boolean flag = level.m_8055_(blockpos3).m_60713_(block) || level.m_8055_(blockpos4).m_60713_(block);
        boolean bl = flag1 = level.m_8055_(blockpos1).m_60713_(block) || level.m_8055_(blockpos2).m_60713_(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = level.m_8055_(blockpos3.m_122012_()).m_60713_(block) || level.m_8055_(blockpos4.m_122012_()).m_60713_(block) || level.m_8055_(blockpos4.m_122019_()).m_60713_(block) || level.m_8055_(blockpos3.m_122019_()).m_60713_(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public record PosAndState(BlockPos blockPos, BlockState state) {
    }
}

