/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.corrupted;

import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CorruptedSlimeLayerBlock
extends SnowLayerBlock {
    public CorruptedSlimeLayerBlock(BlockBehaviour.Properties p_56585_) {
        super(p_56585_);
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(((Integer)state.m_61143_((Property)f_56581_) - 3) * 2, 0), (double)16.0);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        if (this.isFree(level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_()) {
            CorruptedSlimeLayerBlock.spawnProjectile(state, (LevelAccessor)level, pos);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (this.isFree(level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_()) {
            CorruptedSlimeLayerBlock.spawnProjectile(state, level, pos);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    private static void spawnProjectile(BlockState state, LevelAccessor level, BlockPos pos) {
        for (int i = 0; i < (Integer)state.m_61143_((Property)f_56581_); ++i) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            CorruptedProjectile projectile = new CorruptedProjectile((Level)level);
            projectile.m_146884_(pos.m_7495_().m_252807_());
            projectile.m_146926_((float)Math.PI / 90);
            level.m_7967_((Entity)projectile);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float pFallDistance) {
        entity.m_5496_(SoundEvents.f_11968_, 1.0f, 1.0f);
        this.showParticles(entity, 10);
        if (entity.m_142535_(pFallDistance, 0.2f, level.m_269111_().m_268989_())) {
            entity.m_5496_(this.f_60446_.m_56779_(), this.f_60446_.m_56773_() * 0.5f, this.f_60446_.m_56774_() * 0.75f);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        double d0 = Math.abs(entity.m_20184_().f_82480_);
        if (d0 < 0.1 && !entity.m_20161_()) {
            double d1 = 1.0 / (double)((Integer)state.m_61143_((Property)f_56581_) + 1) + d0 * 0.2;
            entity.m_20256_(entity.m_20184_().m_82542_(d1, 1.0, d1));
        }
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public boolean isFree(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || state.m_278721_() || state.m_247087_();
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int layers = (Integer)state.m_61143_((Property)f_56581_);
        if (layers == 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(layers - 1)), 3);
        }
    }

    private void showParticles(Entity entity, int pParticleCount) {
        if (entity.m_9236_().f_46443_) {
            for (int i = 0; i < pParticleCount; ++i) {
                entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_49966_()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.m_60713_((Block)this) && ((Integer)adjacentBlockState.m_61143_((Property)SnowLayerBlock.f_56581_) >= (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) || side.m_122434_().equals((Object)Direction.Axis.Y)) || super.m_6104_(state, adjacentBlockState, side);
    }
}

