/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.components.DirectionStorageHelper;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SyncBlockPatternsPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPatternCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public final Map<BlockPos, PatternData> patterns = new HashMap<BlockPos, PatternData>();
    private final LazyOptional<BlockPatternCapability> optional = LazyOptional.of(() -> this);
    ResourceLocation ID = MoreSnifferFlowers.loc("block_patterns");

    public static BlockPatternCapability getBlockPatterns(BlockPos pos, Level level) {
        LevelChunk levelChunk = (LevelChunk)level.m_46865_(pos);
        return (BlockPatternCapability)levelChunk.getCapability(CapabilityList.BLOCK_PATTERNS).orElse((Object)new BlockPatternCapability());
    }

    public static void setPattern(BlockPos pos, PatternData pattern, Level level) {
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        ChunkPos chunkPos = new ChunkPos(pos);
        level.m_46745_(pos).m_8092_(true);
        capability.setPattern(pos, pattern);
        if (!level.f_46443_) {
            capability.sync(chunkPos);
        }
    }

    public void setPattern(BlockPos pos, PatternData pattern) {
        this.patterns.put(pos.m_7949_(), pattern);
    }

    public static void setBulkPatterns(Map<BlockPos, PatternData> patternMap, Level level) {
        if (level.f_46443_) {
            return;
        }
        for (Map.Entry<BlockPos, PatternData> entry : patternMap.entrySet()) {
            BlockPos pos2 = entry.getKey();
            PatternData patternData = entry.getValue();
            BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos2, level);
            capability.setPattern(pos2, patternData);
            level.m_46745_(pos2).m_8092_(true);
        }
        Set<BlockPos> blockPosList = patternMap.keySet();
        Set chunkPositions = blockPosList.stream().map(ChunkPos::new).collect(Collectors.toSet());
        List<LevelChunk> levelChunks = chunkPositions.stream().map(pos -> level.m_6325_(pos.f_45578_, pos.f_45579_)).toList();
        for (LevelChunk levelChunk : levelChunks) {
            levelChunk.getCapability(CapabilityList.BLOCK_PATTERNS).ifPresent(blockPatternCapability -> blockPatternCapability.sync(levelChunk.m_7697_()));
        }
    }

    public static PatternData getPattern(BlockPos pos, Level level) {
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        return capability.getPattern(pos);
    }

    public PatternData getPattern(BlockPos pos) {
        return this.patterns.get(pos);
    }

    public static boolean hasPattern(BlockPos pos, Level level) {
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        return capability.hasPattern(pos);
    }

    public boolean hasPattern(BlockPos pos) {
        return this.patterns.containsKey(pos);
    }

    public static void removePattern(BlockPos pos, Level level) {
        BlockPatternCapability capability = BlockPatternCapability.getBlockPatterns(pos, level);
        capability.removePattern(pos);
        level.m_46745_(pos).m_8092_(true);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            capability.sync(new ChunkPos(pos));
        }
    }

    public void removePattern(BlockPos pos) {
        this.patterns.remove(pos);
    }

    public Stream<BlockPos> getPatternPositionsNear(BlockPos pos, int renderDistance) {
        return this.patterns.keySet().stream().filter(p -> p.m_123314_((Vec3i)pos, (double)renderDistance));
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    public void sync(ChunkPos pos) {
        CompoundTag compoundtag = this.save(new CompoundTag());
        ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncBlockPatternsPacket(compoundtag, pos));
    }

    public int count() {
        return this.patterns.size();
    }

    public static void recolor(Level level, BlockPos pos, int color) {
        PatternData data = BlockPatternCapability.getPattern(pos, level);
        BlockPatternCapability.setPattern(pos, new PatternData(data.patternId, color, data.direction, data.isGlowing), level);
        level.m_46745_(pos).m_8092_(true);
    }

    public static void enableGlowing(Level level, BlockPos pos) {
        PatternData data = BlockPatternCapability.getPattern(pos, level);
        BlockPatternCapability.setPattern(pos, new PatternData(data.patternId, data.color, data.direction, true), level);
        level.m_46745_(pos).m_8092_(true);
    }

    public CompoundTag save() {
        return this.save(new CompoundTag());
    }

    public CompoundTag save(CompoundTag tag) {
        ListTag patternList = new ListTag();
        for (Map.Entry<BlockPos, PatternData> entry : this.patterns.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
            entryTag.m_128365_("data", (Tag)entry.getValue().save());
            patternList.add((Object)entryTag);
        }
        tag.m_128365_("all", (Tag)patternList);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.patterns.clear();
        ListTag patternList = tag.m_128437_("all", 10);
        for (Tag tag1 : patternList) {
            CompoundTag entry = (CompoundTag)tag1;
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)entry.m_128469_("pos"));
            PatternData data = PatternData.load(entry.m_128469_("data"));
            this.patterns.put(pos, data);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityList.BLOCK_PATTERNS ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.save();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.load(nbt);
    }

    public void invalidate() {
        this.optional.invalidate();
    }

    public record PatternData(int patternId, int color, Direction direction, boolean isGlowing) {
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("pat", this.patternId);
            tag.m_128405_("color", this.color);
            tag.m_128405_("dir", DirectionStorageHelper.directionToInt(this.direction));
            tag.m_128379_("glow", this.isGlowing);
            return tag;
        }

        public static PatternData load(CompoundTag tag) {
            int patternId = tag.m_128451_("pat");
            int color = tag.m_128451_("color");
            Direction direction1 = DirectionStorageHelper.intToDirection(tag.m_128451_("dir"));
            boolean isGlowing = tag.m_128471_("glow");
            return new PatternData(patternId, color, direction1, isGlowing);
        }
    }
}

